/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools.views;

import com.militsa.tools.ArrayOfChars;
import com.militsa.tools.mvc.Dependent;
import com.militsa.tools.mvc.Model;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;

public class ToStringView
extends Canvas
implements Dependent {
    public Object model;
    public Font font;
    public boolean usingCache = false;
    public String[] cachedLines;
    int marginx = -1;
    int marginy = -1;

    public ToStringView(Object obj) {
        this(obj, null);
    }

    public ToStringView(Object obj, Font font) {
        this(obj, font, true);
    }

    public ToStringView(Object obj, Font font, boolean usingCachedLines) {
        if (obj == null) {
            obj = "null";
        }
        this.setModel(obj);
        this.font = font;
        this.usingCache = usingCachedLines;
    }

    public ToStringView(Object obj, boolean usingCachedLines) {
        this(obj, null, usingCachedLines);
    }

    public String[] computeLines() {
        char[][] arrays = ArrayOfChars.slices(this.modelAsString().toCharArray(), '\n');
        int length = arrays.length;
        String[] result = new String[length];
        int i = length;
        while (--i >= 0) {
            result[i] = new String(arrays[i]).replace('\t', ' ');
        }
        return result;
    }

    public void drawLines(Graphics gc) {
        Font oldFont = gc.getFont();
        gc.setFont(this.font);
        gc.setColor(Color.black);
        String[] lines = this.getLines();
        int height = this.font.getSize();
        int increment = this.nextLineY(height);
        int x = this.marginx;
        int y = this.marginy + height;
        int length = lines.length;
        for (int i = 0; i < length; ++i) {
            gc.drawString(lines[i], x, y);
            y += increment;
        }
        gc.setFont(oldFont);
    }

    public String[] getLines() {
        if (this.usingCache) {
            if (this.cachedLines == null) {
                this.cachedLines = this.computeLines();
            }
            return this.cachedLines;
        }
        return this.computeLines();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics2D gc = (Graphics2D)this.getGraphics();
        if (this.font == null) {
            this.font = gc.getFont();
        }
        int height = this.font.getSize();
        if (this.marginx == -1) {
            this.setMarginxy(height, this.marginy);
        }
        if (this.marginy == -1) {
            this.setMarginxy(this.marginx, height);
        }
        String[] lines = this.getLines();
        int increment = this.nextLineY(height);
        int allHeight = this.marginy + height + this.marginy;
        if (lines.length > 1) {
            allHeight += increment * (lines.length - 1);
        }
        int width = 50;
        int i = lines.length;
        while (--i >= 0) {
            Rectangle2D rec = this.font.getStringBounds(lines[i], gc.getFontRenderContext());
            int w = (int)rec.getWidth();
            if (w <= width) continue;
            width = w;
        }
        return new Dimension(width + this.marginx + this.marginx, allHeight);
    }

    public static void main(String[] args) {
        final Frame f = new Frame("Test ToStringView");
        StringBuffer stream = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                stream.append("\n");
            }
            stream.append(args[i]);
        }
        f.add("Center", new ToStringView(stream));
        WindowAdapter wl = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                f.setVisible(false);
                f.dispose();
                System.exit(0);
            }
        };
        f.addWindowListener(wl);
        f.pack();
        f.setSize(f.getPreferredSize());
        throw new RuntimeException();
    }

    public String modelAsString() {
        return this.model.toString();
    }

    @Override
    public void modelHasChanged(Object param) {
        this.repaint();
    }

    public int nextLineY(int fontheight) {
        return fontheight + fontheight / 3;
    }

    @Override
    public void paint(Graphics gc) {
        gc.setColor(this.getBackground());
        gc.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawLines(gc);
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public void setMarginxy(int x, int y) {
        if (x < 0) {
            x = -1;
        }
        if (y < 0) {
            y = -1;
        }
        this.marginx = x;
        this.marginy = y;
    }

    @Override
    public void setModel(Model obj) {
        this.setModel((Object)obj);
    }

    public void setModel(Object obj) {
        if (this.model instanceof Model) {
            ((Model)this.model).removeDependent(this);
        }
        this.model = obj;
        this.cachedLines = null;
        if (this.model instanceof Model) {
            ((Model)this.model).addDependent(this);
        }
        this.repaint();
    }
}

