/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools.views;

import com.militsa.tools.views.ToStringView;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Dialog {
    public static boolean confirm(String text) {
        return Dialog.confirm(text, true);
    }

    public static boolean confirm(String text, boolean initialValue) {
        return Dialog.confirm(text, initialValue, "? ? ?");
    }

    public static boolean confirm(String text, boolean initialValue, String label) {
        return Dialog.confirm(text, initialValue, label, "Yes", "No ");
    }

    public static boolean confirm(String text, final boolean initialValue, String label, String yes, String no) {
        final java.awt.Dialog dialog = new java.awt.Dialog(new Frame(), label, true);
        final boolean[] value = new boolean[]{initialValue};
        final WindowAdapter wl = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                value[0] = false;
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        dialog.addWindowListener(wl);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        dialog.setLayout(gridbag);
        gridbag.setConstraints(dialog, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        ToStringView tsv = new ToStringView(text);
        gridbag.setConstraints(tsv, c);
        dialog.add(tsv);
        c.gridwidth = -1;
        c.weighty = 0.0;
        c.fill = 0;
        Button b = new Button(initialValue ? yes : no);
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                value[0] = initialValue;
                dialog.setVisible(false);
                dialog.removeWindowListener(wl);
                dialog.dispose();
            }
        };
        b.addActionListener(action);
        gridbag.setConstraints(b, c);
        dialog.add(b);
        c.gridwidth = 0;
        b = new Button(initialValue ? no : yes);
        action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                value[0] = !initialValue;
                dialog.setVisible(false);
                dialog.removeWindowListener(wl);
                dialog.dispose();
            }
        };
        b.addActionListener(action);
        gridbag.setConstraints(b, c);
        dialog.add(b);
        dialog.pack();
        dialog.setSize(dialog.getPreferredSize());
        Dialog.moveToCenter(dialog);
        dialog.setVisible(true);
        return value[0];
    }

    public static void main(String[] args) {
        Dialog.confirm("Please, answer to the next question : \nAre you over 18 ?", true);
        System.exit(0);
    }

    public static void moveToCenter(Component c) {
        Dimension cDim = c.getPreferredSize();
        Dimension screenDim = c.getToolkit().getScreenSize();
        int x = screenDim.width / 2 - cDim.width / 2;
        int y = screenDim.height / 2 - cDim.height / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        c.setLocation(x, y);
    }

    public static void warm(String text, String label) {
        final java.awt.Dialog dialog = new java.awt.Dialog(new Frame(), label, true);
        final WindowAdapter wl = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        dialog.addWindowListener(wl);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        dialog.setLayout(gridbag);
        gridbag.setConstraints(dialog, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        ToStringView tsv = new ToStringView(text);
        gridbag.setConstraints(tsv, c);
        dialog.add(tsv);
        c.weighty = 0.0;
        c.fill = 0;
        Button b = new Button("OK");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.removeWindowListener(wl);
                dialog.dispose();
            }
        };
        b.addActionListener(action);
        gridbag.setConstraints(b, c);
        dialog.add(b);
        dialog.pack();
        dialog.setSize(dialog.getPreferredSize());
        throw new RuntimeException();
    }
}

