/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools.math;

import com.militsa.tools.math.ArrangementTreatment;
import com.militsa.tools.math.StopGeneration;

public class Arrangements {
    public static void generateArrangements(int nbElements, int nbSets, ArrangementTreatment at) throws StopGeneration {
        Arrangements.generateAllPossibleSets(nbElements, nbSets, new int[nbSets], 0, nbElements, at);
    }

    private static void generateAllPossibleSets(int nbRemainingElements, int nbSets, int[] setsLengths, int setsLengthsPtr, int nbElements, ArrangementTreatment at) throws StopGeneration {
        at.checkElapsedTime();
        if (nbSets == 0) {
            if (at.checkConstraintsSets(setsLengths)) {
                int[] elementsGroup = new int[nbElements];
                for (int i = 0; i < nbElements; ++i) {
                    elementsGroup[i] = -1;
                }
                int length = setsLengths.length;
                Arrangements.generateAllPossibleGroups(elementsGroup, setsLengths, length - 1, setsLengths[length - 1], new int[length], false, -1, at);
            }
        } else {
            int previousLength;
            int maxLength = nbRemainingElements - nbSets + 1;
            int n = previousLength = setsLengthsPtr == 0 ? 1 : setsLengths[setsLengthsPtr - 1];
            if (nbSets == 1) {
                if (maxLength >= previousLength) {
                    setsLengths[setsLengthsPtr] = maxLength;
                    Arrangements.generateAllPossibleSets(0, 0, setsLengths, setsLengthsPtr + 1, nbElements, at);
                }
            } else {
                for (int i = previousLength; i <= maxLength; ++i) {
                    setsLengths[setsLengthsPtr] = i;
                    Arrangements.generateAllPossibleSets(nbRemainingElements - i, nbSets - 1, setsLengths, setsLengthsPtr + 1, nbElements, at);
                }
            }
        }
    }

    public static void generateAllPossibleGroups(int[] elementsGroup, int[] setsLengths, int currentSet, int currentSetLength, int[] firstIndexForSets, boolean sameLengthThanPreviousSet, int lastIndexForCurrentSet, ArrangementTreatment at) throws StopGeneration {
        boolean firstIndex;
        at.checkElapsedTime();
        if (currentSetLength == 0) {
            if (!at.checkConstraints(elementsGroup, setsLengths, currentSet)) {
                return;
            }
            if (currentSet == 0) {
                at.execute(elementsGroup, setsLengths);
            } else {
                boolean sameLengthThanPrevious = setsLengths[currentSet] == setsLengths[currentSet - 1];
                Arrangements.generateAllPossibleGroups(elementsGroup, setsLengths, currentSet - 1, setsLengths[currentSet - 1], firstIndexForSets, sameLengthThanPrevious, -1, at);
            }
        }
        int elementsGroupLength = elementsGroup.length;
        boolean bl = firstIndex = setsLengths[currentSet] == currentSetLength;
        int i = firstIndex ? (sameLengthThanPreviousSet ? firstIndexForSets[currentSet + 1] + 1 : 0) : lastIndexForCurrentSet + 1;
        while (i < elementsGroupLength) {
            if (elementsGroup[i] == -1) {
                elementsGroup[i] = currentSet;
                if (firstIndex) {
                    firstIndexForSets[currentSet] = i;
                }
                Arrangements.generateAllPossibleGroups(elementsGroup, setsLengths, currentSet, currentSetLength - 1, firstIndexForSets, sameLengthThanPreviousSet, i, at);
                elementsGroup[i] = -1;
            }
            ++i;
        }
    }
}

