/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools.graphsupport;

import java.util.ArrayList;

public class TransitiveCloture {
    public Object[] input;
    public int[][] matrice;
    public int size;

    public TransitiveCloture(Object[] input) {
        this.size = input.length;
        this.input = input;
        this.matrice = new int[this.size][];
        int i = this.size;
        while (--i >= 0) {
            this.matrice[i] = new int[this.size];
        }
    }

    public boolean link(Object a, Object b) {
        int indexA = -1;
        int indexB = -1;
        int i = this.size;
        while (--i >= 0 && indexA != -1 && indexB != -1) {
            if (this.input[i] == a) {
                indexA = i;
            }
            if (this.input[i] != b) continue;
            indexB = i;
        }
        if (indexA == -1 || indexB == -1) {
            return false;
        }
        this.matrice[indexA][indexB] = 1;
        return true;
    }

    public boolean link(Object a, Object[] lst) {
        return this.link(a, lst, 0, lst.length - 1);
    }

    public boolean link(Object a, Object[] lst, int firstPos, int lastPos) {
        int indexA = -1;
        int i = this.size;
        while (--i >= 0) {
            if (this.input[i] != a) continue;
            indexA = i;
            break;
        }
        if (indexA == -1) {
            return false;
        }
        boolean ok = true;
        for (int i2 = lastPos; i2 >= firstPos; --i2) {
            ok = ok && this.link(indexA, lst[i2]);
        }
        return ok;
    }

    public boolean linkAll(Object[] lst) {
        int nb = lst.length;
        int size = this.size;
        int[] indexes = new int[nb];
        int ptr = -1;
        for (int x = 0; x < nb; ++x) {
            int currentPtr = ptr;
            Object obj = lst[x];
            int i = size;
            while (--i >= 0) {
                if (this.input[i] != obj) continue;
                indexes[++ptr] = i;
                break;
            }
            if (currentPtr != ptr) continue;
            return false;
        }
        for (int i = 0; i < nb - 1; ++i) {
            int indexA = indexes[i];
            int[] lineA = this.matrice[indexA];
            int j = i;
            while (++j < nb) {
                int indexB = indexes[j];
                lineA[indexB] = 1;
            }
        }
        return true;
    }

    private boolean link(int indexA, Object b) {
        int indexB = -1;
        int i = this.size;
        while (--i >= 0) {
            if (this.input[i] != b) continue;
            indexB = i;
            break;
        }
        if (indexB == -1) {
            return false;
        }
        this.matrice[indexA][indexB] = 1;
        return true;
    }

    public ArrayList getDisjointSet() {
        this.doReflexion();
        this.doTransitiveClosure();
        return this.computeDisjointSet();
    }

    public void doReflexion() {
        int i = this.size;
        while (--i >= 0) {
            int[] lineI = this.matrice[i];
            int j = this.size;
            while (--j > i) {
                if (lineI[j] != 1) continue;
                this.matrice[j][i] = 1;
            }
        }
    }

    public void doTransitiveClosure() {
        int i = this.size;
        while (--i >= 0) {
            this.matrice[i][i] = 1;
        }
        for (i = 0; i < this.size; ++i) {
            int[] lineI = this.matrice[i];
            for (int s = 0; s < this.size; ++s) {
                int[] lineS = this.matrice[s];
                if (lineS[i] != 1) continue;
                for (int t = 0; t < this.size; ++t) {
                    if (lineI[t] != 1) continue;
                    lineS[t] = 1;
                }
            }
        }
    }

    private ArrayList computeDisjointSet() {
        ArrayList<int[]> disjointSet = new ArrayList<int[]>(this.size >> 1);
        int[] stateInputs = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (stateInputs[i] != 0) continue;
            int[] lineI = this.matrice[i];
            int nb = 0;
            for (int j = 0; j < this.size; ++j) {
                nb += lineI[j];
            }
            int[] currentSet = new int[nb];
            int ptr = -1;
            for (int j = 0; j < this.size; ++j) {
                if (lineI[j] != 1) continue;
                currentSet[++ptr] = j;
                stateInputs[j] = 1;
            }
            disjointSet.add(currentSet);
            stateInputs[i] = 1;
        }
        return disjointSet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            int[] line = this.matrice[i];
            sb.append("[");
            for (int j = 0; j < this.size; ++j) {
                if (line[j] != 1) continue;
                sb.append("(").append(this.input[i]).append('-').append(this.input[j]).append("),");
            }
            sb.append("]\n");
        }
        return sb.toString();
    }
}

