/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools.graphsupport;

import com.militsa.tools.graphsupport.Arc;
import com.militsa.tools.graphsupport.GraphElement;
import com.militsa.tools.graphsupport.GraphException;

public class Node
extends GraphElement {
    private static final int DefaultSize = 10;
    public Arc[] sources;
    public int sourcesPtr;
    public Arc[] destinations;
    public int destinationsPtr;

    public Node() {
    }

    public Node(Object o) {
        this.generic = o;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sourcesPtr = -1;
        this.destinationsPtr = -1;
        this.sources = null;
        this.destinations = null;
    }

    @Override
    public String name() {
        return "node_" + this.graphPosition;
    }

    public int degre() {
        int degre = this.sourcesPtr + this.destinationsPtr + 1 + 1;
        int i = this.sourcesPtr + 1;
        while (--i >= 0) {
            if (!this.sources[i].bidirectional) continue;
            --degre;
        }
        return degre;
    }

    public Node[] neighbourgs() {
        Arc arc;
        int guessdegre = this.sourcesPtr + this.destinationsPtr + 1 + 1;
        Node[] nodes = new Node[guessdegre];
        int ptr = -1;
        int i = this.sourcesPtr + 1;
        while (--i >= 0) {
            arc = this.sources[i];
            if (!arc.bidirectional) {
                nodes[++ptr] = arc.destination;
                continue;
            }
            if (arc.source == this) {
                nodes[++ptr] = arc.destination;
                continue;
            }
            nodes[++ptr] = arc.source;
        }
        i = this.destinationsPtr + 1;
        while (--i >= 0) {
            if (this.destinations[i].bidirectional) continue;
            arc = this.destinations[i];
            if (!arc.bidirectional) {
                nodes[++ptr] = arc.destination;
                continue;
            }
            if (arc.destination == this) {
                nodes[++ptr] = arc.source;
                continue;
            }
            nodes[++ptr] = arc.destination;
        }
        if (ptr != guessdegre + 1) {
            Node[] nodeArray = nodes;
            nodes = new Node[ptr + 1];
            System.arraycopy(nodeArray, 0, nodes, 0, ptr + 1);
        }
        return nodes;
    }

    public void addSource(Arc arc) {
        if (!(arc.source == this || arc.bidirectional && arc.destination == this)) {
            throw new GraphException();
        }
        if (this.sources == null) {
            this.sources = new Arc[10];
        }
        try {
            this.sources[++this.sourcesPtr] = arc;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.sources = new Arc[this.sourcesPtr + this.sourcesPtr];
            System.arraycopy(this.sources, 0, this.sources, 0, this.sourcesPtr);
            this.sources[this.sourcesPtr] = arc;
        }
    }

    public void removeSource(Arc arc) {
        if (!(arc.source == this || arc.bidirectional && arc.destination == this)) {
            throw new GraphException();
        }
        int i = this.sourcesPtr + 1;
        while (--i >= 0) {
            if (this.sources[i] != arc) continue;
            System.arraycopy(this.sources, i + 1, this.sources, i, this.sourcesPtr - i);
            --this.sourcesPtr;
            return;
        }
    }

    public void removeDestination(Arc arc) {
        if (!(arc.destination == this || arc.bidirectional && arc.source == this)) {
            throw new GraphException();
        }
        int i = this.destinationsPtr + 1;
        while (--i >= 0) {
            if (this.destinations[i] != arc) continue;
            System.arraycopy(this.destinations, i + 1, this.destinations, i, this.destinationsPtr - i);
            --this.destinationsPtr;
            return;
        }
    }

    public void addDestination(Arc arc) {
        if (!(arc.destination == this || arc.bidirectional && arc.source == this)) {
            throw new GraphException();
        }
        if (this.destinations == null) {
            this.destinations = new Arc[10];
        }
        try {
            this.destinations[++this.destinationsPtr] = arc;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.destinations = new Arc[this.destinationsPtr + this.destinationsPtr];
            System.arraycopy(this.destinations, 0, this.destinations, 0, this.destinationsPtr);
            this.destinations[this.destinationsPtr] = arc;
        }
    }
}

