/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

import com.militsa.tools.DefaultReader;
import com.militsa.tools.NotClosableReader;
import com.militsa.tools.TimeoutInputStreamReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;

public class TimeoutInputStream
extends FilterInputStream {
    private TimeoutInputStreamReader reader;

    public TimeoutInputStream(InputStream in) {
        this(in, in != System.in);
    }

    public TimeoutInputStream(InputStream in, boolean closableStream) {
        super(in);
        this.reader = closableStream ? new DefaultReader(in) : new NotClosableReader(in);
    }

    public int read(long timeout) throws TimeoutException, IOException {
        return this.reader.read(timeout);
    }

    public int read(byte[] b, long timeout) throws IOException, TimeoutException {
        return this.read(b, 0, b.length, timeout);
    }

    public int read(byte[] b, int off, int len, long timeout) throws IOException, TimeoutException {
        return this.reader.read(b, off, len, timeout);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reader.close();
    }
}

