/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

import com.militsa.tools.IntToIntTable;

public class StateSymbolTable {
    private static final int DefaultNbHashEntries = 1000;
    private char[] utf8AsCharBuffer;
    public int newState = -1;
    public int frontSize;
    char[][] identifiers;
    int nbIdentifiers;
    IntToIntTable stateToIdentifierTable;
    public int[][] states;
    public int[] statesIndex;
    public static long sum;
    public static int nbLoadedSymbols;

    public StateSymbolTable(int nbHashEntries) {
        this.frontSize = nbHashEntries;
        this.states = new int[this.frontSize][];
        this.statesIndex = new int[this.frontSize];
        int i = this.frontSize;
        while (i-- > 0) {
            this.states[i] = new int[12];
        }
        this.identifiers = new char[500][];
        this.stateToIdentifierTable = new IntToIntTable(200);
    }

    public StateSymbolTable() {
        this(1000);
    }

    public int convertStateToId(int state) {
        int id = this.stateToIdentifierTable.at(state);
        if (id == 0) {
            id = this.nbIdentifiers + 1;
            this.stateToIdentifierTable.atPut(state, id);
        }
        return id;
    }

    public final char[] getCharArray(byte[] source, int start, int stop) {
        int index = this.getUtf8Index(source, start, stop);
        return this.getCharArrayFromIndex(index, this.utf8AsCharBuffer, 0, this.utf8AsCharBuffer.length);
    }

    public final char[] getCharArray(String str) {
        return this.getCharArray(str.toCharArray());
    }

    public final char[] getCharArray(char[] source) {
        return this.getCharArray(source, 0, source.length);
    }

    public final char[] getCharArray(char[] source, int start, int stop) {
        int index = this.getCharArrayIndex(source, start, stop);
        return this.getCharArrayFromIndex(index, source, start, stop);
    }

    public final char[][] getCharArrayArray(byte[] source, int start, int stop) {
        int[] forwardSlashes = new int[20];
        int ptr = -1;
        for (int i = start; i < stop; ++i) {
            if (source[i] != 47) continue;
            try {
                forwardSlashes[++ptr] = i;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                int[] nArray = forwardSlashes;
                forwardSlashes = new int[ptr + 20];
                System.arraycopy(nArray, 0, forwardSlashes, 0, ptr);
                forwardSlashes[++ptr] = i;
            }
        }
        if (ptr < 0) {
            return new char[][]{this.getCharArray(source, start, stop)};
        }
        char[][] result = new char[ptr + 2][];
        int begin = start;
        for (int i = 0; i <= ptr; ++i) {
            int end = forwardSlashes[i];
            result[i] = this.getCharArray(source, begin, end);
            begin = end + 1;
        }
        result[i] = this.getCharArray(source, begin, stop);
        return result;
    }

    public final char[] getCharArrayFromIndex(int index, char[] source, int start, int stop) {
        char[] identifier;
        if (index <= this.nbIdentifiers) {
            return this.identifiers[index];
        }
        this.nbIdentifiers = index;
        try {
            identifier = new char[stop - start];
            this.identifiers[index] = identifier;
            System.arraycopy(source, start, identifier, 0, stop - start);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            int lg = this.identifiers.length;
            char[][] cArrayArray = new char[index + this.frontSize][];
            this.identifiers = cArrayArray;
            System.arraycopy(this.identifiers, 0, cArrayArray, 0, lg);
            identifier = new char[stop - start];
            this.identifiers[index] = identifier;
            System.arraycopy(source, start, identifier, 0, stop - start);
        }
        return identifier;
    }

    private int getCharArrayIndex(char[] source, int start, int stop) {
        int state = -1;
        int c2 = 26;
        int k = start - 1;
        while (++k < stop) {
            int c1 = c2;
            c2 = source[k];
            int test = (c1 << 16) + c2;
            int hash = (test + (k - start << 8) & Integer.MAX_VALUE) % this.frontSize;
            int[] subStates = this.states[hash];
            int length = this.statesIndex[hash];
            boolean found = false;
            int i = length;
            while ((i -= 3) >= 0) {
                if (subStates[i] != test || subStates[i + 1] != state) continue;
                state = subStates[i + 2];
                found = true;
                break;
            }
            if (found) continue;
            if (length == subStates.length) {
                int[] newSubStates = new int[length * 2];
                System.arraycopy(subStates, 0, newSubStates, 0, length);
                subStates = newSubStates;
                this.states[hash] = newSubStates;
            }
            subStates[length] = test;
            subStates[length + 1] = state;
            state = ++this.newState;
            subStates[length + 2] = this.newState;
            this.statesIndex[hash] = length + 3;
        }
        return this.convertStateToId(state);
    }

    public char[][] internCharArrays(char[][] array) {
        return this.internCharArrays(array, 0, array.length);
    }

    public char[][] internCharArrays(char[][] array, int offset, int length) {
        char[][] result = new char[length][];
        int i = length;
        while (--i >= 0) {
            char[] sub = array[offset + i];
            result[i] = this.getCharArray(sub, 0, sub.length);
        }
        return result;
    }

    private final int getUtf8Index(byte[] source, int start, int stop) {
        char[] buffer = new char[stop - start];
        int bufferPtr = 0;
        int state = -1;
        int c2 = 26;
        for (int k = start; k < stop; ++k) {
            int c1 = c2;
            int b1 = source[k] & 0xFF;
            c2 = (b1 & 0x80) == 0 ? (int)((char)b1) : ((b1 & 0x20) == 0 ? (int)((char)((b1 & 0x1F) << 6 | source[++k] & 0x3F)) : (int)((char)((b1 & 0xF) << 12 | (source[++k] & 0x3F) << 6 | source[++k] & 0x3F)));
            buffer[bufferPtr++] = c2;
            int test = (c1 << 16) + c2;
            int hash = (test + (bufferPtr - 1 << 8) & Integer.MAX_VALUE) % this.frontSize;
            int[] subStates = this.states[hash];
            int length = this.statesIndex[hash];
            boolean found = false;
            int i = length;
            while ((i -= 3) >= 0) {
                if (subStates[i] != test || subStates[i + 1] != state) continue;
                state = subStates[i + 2];
                found = true;
                break;
            }
            if (found) continue;
            if (length == subStates.length) {
                int[] newSubStates = new int[length * 2];
                System.arraycopy(subStates, 0, newSubStates, 0, length);
                subStates = newSubStates;
                this.states[hash] = newSubStates;
            }
            subStates[length] = test;
            subStates[length + 1] = state;
            state = ++this.newState;
            subStates[length + 2] = this.newState;
            this.statesIndex[hash] = length + 3;
        }
        this.utf8AsCharBuffer = new char[bufferPtr];
        System.arraycopy(buffer, 0, this.utf8AsCharBuffer, 0, bufferPtr);
        return this.convertStateToId(state);
    }
}

