/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

import com.militsa.tools.ComparableObject;
import com.militsa.tools.Comparator;

public class Sort {
    public static void bubbleSort(int[] array, int start, int stop) {
        int i = stop + 1;
        while (--i > start) {
            int j = start - 1;
            while (++j < i) {
                if (array[j] <= array[j + 1]) continue;
                int tmp = array[j];
                array[j] = array[j + 1];
                array[j + 1] = tmp;
            }
        }
    }

    public static void bubbleSort(int[] array, int start, int stop, int[] b) {
        int i = stop + 1;
        while (--i > start) {
            int j = start - 1;
            while (++j < i) {
                if (array[j] <= array[j + 1]) continue;
                int tmp = array[j];
                array[j] = array[j + 1];
                array[j + 1] = tmp;
                tmp = b[j];
                b[j] = b[j + 1];
                b[j + 1] = tmp;
            }
        }
    }

    public static void quickSort(int[] a, int l, int r) {
        int tmp;
        if (r - l <= 5) {
            Sort.bubbleSort(a, l, r);
            return;
        }
        int i = l - 1;
        int j = r;
        int v = a[r];
        while (true) {
            if (a[++i] < v) {
                continue;
            }
            while (v < a[--j] && j != l) {
            }
            if (i >= j) break;
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
        tmp = a[i];
        a[i] = a[r];
        a[r] = tmp;
        if (i - l < r - i) {
            Sort.quickSort(a, l, i - 1);
            Sort.quickSort(a, i + 1, r);
        } else {
            Sort.quickSort(a, i + 1, r);
            Sort.quickSort(a, l, i - 1);
        }
    }

    public static void quickSort(int[] a, int l, int r, int[] b) {
        int tmp;
        if (r - l <= 5) {
            Sort.bubbleSort(a, l, r, b);
            return;
        }
        int i = l - 1;
        int j = r;
        int v = a[r];
        while (true) {
            if (a[++i] < v) {
                continue;
            }
            while (v < a[--j] && j != l) {
            }
            if (i >= j) break;
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
            tmp = b[i];
            b[i] = b[j];
            b[j] = tmp;
        }
        tmp = a[i];
        a[i] = a[r];
        a[r] = tmp;
        tmp = b[i];
        b[i] = b[r];
        b[r] = tmp;
        if (i - l < r - i) {
            Sort.quickSort(a, l, i - 1, b);
            Sort.quickSort(a, i + 1, r, b);
        } else {
            Sort.quickSort(a, i + 1, r, b);
            Sort.quickSort(a, l, i - 1, b);
        }
    }

    public static void quickSortNonRecursive(int[] a, int l, int r) {
        int[] stack = new int[32];
        int ptr = -1;
        stack[++ptr] = r;
        stack[++ptr] = l;
        while (ptr > 0) {
            int tmp;
            if ((r = stack[ptr--]) <= (l = stack[ptr--])) continue;
            int v = a[r];
            int i = l - 1;
            int j = r;
            while (true) {
                if (a[++i] < v) {
                    continue;
                }
                while (v < a[--j] && j != l) {
                }
                if (i >= j) break;
                tmp = a[i];
                a[i] = a[j];
                a[j] = tmp;
            }
            tmp = a[i];
            a[i] = a[r];
            a[r] = tmp;
            if (i - l > r - i) {
                stack[++ptr] = i - 1;
                stack[++ptr] = l;
                stack[++ptr] = r;
                stack[++ptr] = i + 1;
                continue;
            }
            stack[++ptr] = r;
            stack[++ptr] = i + 1;
            stack[++ptr] = i - 1;
            stack[++ptr] = l;
        }
    }

    public static void sort(int[] a) {
        Sort.quickSort(a, 0, a.length - 1);
    }

    public static void sort(int[] a, int[] b) {
        if (a.length != b.length) {
            throw new IndexOutOfBoundsException();
        }
        Sort.quickSort(a, 0, a.length - 1, b);
    }

    public static void bubbleSort(ComparableObject[] array, int start, int stop) {
        int i = stop + 1;
        while (--i > start) {
            int j = start - 1;
            while (++j < i) {
                if (!array[j + 1].isLowerThan(array[j])) continue;
                ComparableObject tmp = array[j];
                array[j] = array[j + 1];
                array[j + 1] = tmp;
            }
        }
    }

    public static void bubbleSort(Object[] array, int start, int stop, Comparator comparator) {
        int i = stop + 1;
        while (--i > start) {
            int j = start - 1;
            while (++j < i) {
                if (!comparator.isLowerThan(array[j + 1], array[j])) continue;
                Object tmp = array[j];
                array[j] = array[j + 1];
                array[j + 1] = tmp;
            }
        }
    }

    public static void quickSort(ComparableObject[] a, int l, int r) {
        ComparableObject tmp;
        if (r - l <= 5) {
            Sort.bubbleSort(a, l, r);
            return;
        }
        int i = l - 1;
        int j = r;
        ComparableObject v = a[r];
        while (true) {
            if (a[++i].isLowerThan(v)) {
                continue;
            }
            while (v.isLowerThan(a[--j]) && j != l) {
            }
            if (i >= j) break;
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
        tmp = a[i];
        a[i] = a[r];
        a[r] = tmp;
        if (i - l < r - i) {
            Sort.quickSort(a, l, i - 1);
            Sort.quickSort(a, i + 1, r);
        } else {
            Sort.quickSort(a, i + 1, r);
            Sort.quickSort(a, l, i - 1);
        }
    }

    public static void quickSort(Object[] a, int l, int r, Comparator comparator) {
        Object tmp;
        if (r - l <= 5) {
            Sort.bubbleSort(a, l, r, comparator);
            return;
        }
        int i = l - 1;
        int j = r;
        Object v = a[r];
        while (true) {
            if (comparator.isLowerThan(a[++i], v)) {
                continue;
            }
            while (comparator.isLowerThan(v, a[--j]) && j != l) {
            }
            if (i >= j) break;
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
        tmp = a[i];
        a[i] = a[r];
        a[r] = tmp;
        if (i - l < r - i) {
            Sort.quickSort(a, l, i - 1, comparator);
            Sort.quickSort(a, i + 1, r, comparator);
        } else {
            Sort.quickSort(a, i + 1, r, comparator);
            Sort.quickSort(a, l, i - 1, comparator);
        }
    }

    public static void sort(ComparableObject[] a) {
        Sort.quickSort(a, 0, a.length - 1);
    }

    public static void sort(Object[] a, Comparator comparator) {
        Sort.quickSort(a, 0, a.length - 1, comparator);
    }

    public static void sort(ComparableObject[] a, int aPtr) {
        Sort.quickSort(a, 0, aPtr);
    }

    public static void bubbleSort(int[] array, int start, int stop, Object[] b) {
        int i = stop + 1;
        while (--i > start) {
            int j = start - 1;
            while (++j < i) {
                if (array[j] <= array[j + 1]) continue;
                int tmp = array[j];
                array[j] = array[j + 1];
                array[j + 1] = tmp;
                Object tmpObj = b[j];
                b[j] = b[j + 1];
                b[j + 1] = tmpObj;
            }
        }
    }

    public static void quickSort(int[] a, int l, int r, Object[] b) {
        Object tmpObj;
        int tmp;
        if (r - l <= 5) {
            Sort.bubbleSort(a, l, r, b);
            return;
        }
        int i = l - 1;
        int j = r;
        int v = a[r];
        while (true) {
            if (a[++i] < v) {
                continue;
            }
            while (v < a[--j] && j != l) {
            }
            if (i >= j) break;
            tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
            tmpObj = b[i];
            b[i] = b[j];
            b[j] = tmpObj;
        }
        tmp = a[i];
        a[i] = a[r];
        a[r] = tmp;
        tmpObj = b[i];
        b[i] = b[r];
        b[r] = tmpObj;
        if (i - l < r - i) {
            Sort.quickSort(a, l, i - 1, b);
            Sort.quickSort(a, i + 1, r, b);
        } else {
            Sort.quickSort(a, i + 1, r, b);
            Sort.quickSort(a, l, i - 1, b);
        }
    }

    public static void sort(int[] a, Object[] b) {
        if (a.length != b.length) {
            throw new IndexOutOfBoundsException();
        }
        Sort.quickSort(a, 0, a.length - 1, b);
    }
}

