/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

public class SimpleVector {
    public Object[] objects;
    public int objectsPtr;

    public SimpleVector() {
        this(10);
    }

    public SimpleVector(int defaultSize) {
        this.objects = new Object[defaultSize];
        this.objectsPtr = -1;
    }

    public void reset() {
        this.objectsPtr = -1;
    }

    public int add(Object o) {
        try {
            this.objects[++this.objectsPtr] = o;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.objects = new Object[this.objectsPtr * 2];
            System.arraycopy(this.objects, 0, this.objects, 0, this.objectsPtr);
            this.objects[this.objectsPtr] = o;
        }
        return this.objectsPtr;
    }

    public int addAll(Object[] lst) {
        int size = lst.length;
        for (int i = 0; i < size; ++i) {
            this.add(lst[i]);
        }
        return this.objectsPtr;
    }

    public int addAllOnce(Object[] lst) {
        int size = lst.length;
        for (int i = 0; i < size; ++i) {
            this.addOnce(lst[i]);
        }
        return this.objectsPtr;
    }

    public int add(SimpleVector other) {
        Object[] otherObjects = other.objects;
        int nbObjects = other.nbObjects();
        int i = -1;
        while (++i < nbObjects) {
            this.add(otherObjects[i]);
        }
        return this.objectsPtr;
    }

    public int addOnce(Object o) {
        int i = this.objectsPtr + 1;
        while (--i >= 0) {
            if (this.objects[i] != o) continue;
            return i;
        }
        return this.add(o);
    }

    public int nbObjects() {
        return this.objectsPtr + 1;
    }

    public void copyToArray(int startOffset, Object[] array, int offset, int length) {
        System.arraycopy(this.objects, startOffset, array, offset, length);
    }

    public void copyToArray(Object[] array, int offset) {
        System.arraycopy(this.objects, 0, array, offset, this.objectsPtr + 1);
    }

    public void copyToArray(Object[] array) {
        this.copyToArray(array, 0);
    }

    public void setNextIndex(int index) {
        this.objectsPtr = index - 1;
    }

    public boolean contains(Object o) {
        return this.getIndex(o) != -1;
    }

    public int getIndex(Object o) {
        Object[] objects = this.objects;
        int i = this.objectsPtr + 1;
        while (--i >= 0) {
            if (objects[i] != o) continue;
            return i;
        }
        return -1;
    }
}

