/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class OS {
    public static final int WatchdogExit = -1;

    private static boolean fetchAvailable(InputStream stream, StringBuffer sb) {
        int available;
        try {
            available = stream.available();
        }
        catch (IOException e) {
            return false;
        }
        if (available > 0) {
            int readOnes;
            byte[] buffer;
            try {
                buffer = new byte[available];
                readOnes = stream.read(buffer);
            }
            catch (IOException e) {
                return false;
            }
            char[] chars = new char[readOnes];
            int i = readOnes;
            while (--i >= 0) {
                chars[i] = (char)buffer[i];
            }
            sb.append(chars);
            return true;
        }
        return false;
    }

    public static int runProcess(Process p, final int allocatedTime, StringBuffer stdOutBuffer, StringBuffer stdErrBuffer) {
        final Process[] process = new Process[]{p};
        InputStream stdOut = process[0].getInputStream();
        InputStream stdErr = process[0].getErrorStream();
        int NotDone = -2;
        final int[] done = new int[]{-2};
        new Thread(new Runnable(){
            int dog = 0;

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    ++this.dog;
                    try {
                        if (process[0] == null) break;
                        done[0] = process[0].exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        if (this.dog <= 2 * allocatedTime || allocatedTime == 0) continue;
                        done[0] = -1;
                        continue;
                    }
                    break;
                }
            }
        }).start();
        try {
            do {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                OS.fetchAvailable(stdOut, stdOutBuffer);
                OS.fetchAvailable(stdErr, stdErrBuffer);
            } while (done[0] == -2);
        }
        catch (Throwable e) {
            done[0] = -1;
        }
        if (done[0] == -1) {
            process[0].destroy();
            process[0] = null;
        }
        System.gc();
        System.runFinalization();
        while (OS.fetchAvailable(stdOut, stdOutBuffer) || OS.fetchAvailable(stdErr, stdErrBuffer)) {
        }
        return done[0];
    }

    public static int runCommand(String command, String[] environment, int allocatedTime, StringBuffer stdOutBuffer, StringBuffer stdErrBuffer) {
        Process p;
        try {
            p = Runtime.getRuntime().exec(command, environment);
        }
        catch (Throwable e) {
            StringBuffer sb;
            Object object = stdOutBuffer == null ? (stdErrBuffer == null ? null : stdErrBuffer) : (sb = stdOutBuffer);
            if (sb != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(stream);
                e.printStackTrace(ps);
                ps.flush();
                sb.append(stream.toString());
            }
            return 1;
        }
        return OS.runProcess(p, allocatedTime, stdOutBuffer, stdErrBuffer);
    }

    public static int runCommand(String[] command, String[] environment, int allocatedTime, StringBuffer stdOutBuffer, StringBuffer stdErrBuffer) {
        Process p;
        try {
            p = Runtime.getRuntime().exec(command, environment);
        }
        catch (Throwable e) {
            StringBuffer sb;
            Object object = stdOutBuffer == null ? (stdErrBuffer == null ? null : stdErrBuffer) : (sb = stdOutBuffer);
            if (sb != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(stream);
                e.printStackTrace(ps);
                ps.flush();
                sb.append(stream.toString());
            }
            return 1;
        }
        return OS.runProcess(p, allocatedTime, stdOutBuffer, stdErrBuffer);
    }

    public static void runCommand(String cmd) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process[] process = new Process[]{runtime.exec(cmd)};
            InputStream stdOut = process[0].getInputStream();
            InputStream stdErr = process[0].getErrorStream();
            boolean running = true;
            while (running) {
                int outAv = stdOut.available();
                int errAv = stdErr.available();
                if (outAv > 0) {
                    System.out.print((char)stdOut.read());
                }
                if (errAv > 0) {
                    System.out.print((char)stdErr.read());
                }
                if (outAv != 0 || errAv != 0) continue;
                try {
                    process[0].exitValue();
                    running = false;
                }
                catch (IllegalThreadStateException e) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readLine() {
        return OS.readLine(System.in);
    }

    public static String readLine(InputStream in) {
        StringBuffer sb = new StringBuffer();
        try {
            int read;
            while ((read = in.read()) != 10) {
                if (read == -1) {
                    return sb.length() > 0 ? sb.toString() : null;
                }
                sb.append((char)read);
            }
        }
        catch (IOException e) {
            return null;
        }
        return sb.toString();
    }
}

