/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

import com.militsa.tools.TimeoutInputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;

class NotClosableReader
implements TimeoutInputStreamReader {
    private InputStream is;
    private boolean closed;

    public NotClosableReader(InputStream is) {
        this.is = is;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public int read(long timeout) throws TimeoutException, IOException {
        long tStart = System.currentTimeMillis();
        while (this.is.available() == 0) {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (System.currentTimeMillis() - tStart > timeout) {
                throw new TimeoutException();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        return this.is.read();
    }

    @Override
    public int read(byte[] b, int off, int len, long timeout) throws IOException, TimeoutException {
        long tStart = System.currentTimeMillis();
        while (this.is.available() == 0 && !this.closed) {
            if (System.currentTimeMillis() - tStart > timeout) {
                throw new TimeoutException();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        return this.is.read(b, off, len);
    }
}

