/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

public class IntToObjectTable {
    int[] keys;
    Object[] values;
    int keysPtr = -1;
    int valuesPtr = -1;
    int[][] entries;
    static final int Threshold = 21;
    static final int DefaultSize = 500;

    public IntToObjectTable() {
        this(500);
    }

    public IntToObjectTable(int keysSize) {
        this(keysSize, keysSize / 21 + 1);
    }

    public IntToObjectTable(int keysSize, int entriesSize) {
        this.keys = new int[keysSize];
        this.values = new Object[keysSize];
        this.entries = new int[entriesSize][];
        int i = entriesSize;
        while (--i >= 0) {
            this.entries[i] = new int[21];
            this.entries[i][0] = 1;
        }
    }

    public IntToObjectTable(IntToObjectTable src) {
        this.keys = new int[src.keys.length];
        this.keysPtr = src.keysPtr;
        System.arraycopy(src.keys, 0, this.keys, 0, this.keysPtr + 1);
        this.values = new Object[src.values.length];
        this.valuesPtr = src.valuesPtr;
        System.arraycopy(src.values, 0, this.values, 0, this.valuesPtr + 1);
        int length = src.entries.length;
        this.entries = new int[length][];
        while (--length >= 0) {
            int[] srcEntries = src.entries[length];
            this.entries[length] = new int[srcEntries.length];
            System.arraycopy(srcEntries, 0, this.entries[length], 0, srcEntries.length);
        }
    }

    public int hashValue(int key) {
        return (key & Integer.MAX_VALUE) % this.entries.length;
    }

    public Object at(int key) {
        int hash = this.hashValue(key);
        int[] ivalues = this.entries[hash];
        int i = ivalues[0];
        while (--i >= 1) {
            if (key != this.keys[ivalues[--i]]) continue;
            return this.values[ivalues[i + 1]];
        }
        return null;
    }

    public void atPut(int key, Object value) {
        int hash = this.hashValue(key);
        int vl = 0;
        int[] ivalues = this.entries[hash];
        int i = vl = ivalues[0];
        while (--i >= 1) {
            if (key != this.keys[ivalues[--i]]) continue;
            ivalues[i + 1] = this.newIndexForValue(value);
            return;
        }
        if (vl == 21) {
            this.rehash();
            this.atPut(key, value);
            return;
        }
        try {
            this.keys[++this.keysPtr] = key;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.keys = new int[this.keysPtr * 2];
            System.arraycopy(this.keys, 0, this.keys, 0, this.keysPtr);
            this.keys[this.keysPtr] = key;
        }
        ivalues[vl] = this.keysPtr;
        ivalues[vl + 1] = this.newIndexForValue(value);
        ivalues[0] = vl + 2;
    }

    public Object[] values() {
        int ni = this.valuesPtr + 1;
        Object[] newValues = new Object[ni];
        System.arraycopy(this.values, 0, newValues, 0, ni);
        return newValues;
    }

    public int[] keys() {
        int ni = this.keysPtr + 1;
        int[] newKeys = new int[ni];
        System.arraycopy(this.keys, 0, newKeys, 0, ni);
        return newKeys;
    }

    private int newIndexForValue(Object value) {
        try {
            this.values[++this.valuesPtr] = value;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.values = new Object[this.valuesPtr * 2];
            System.arraycopy(this.values, 0, this.values, 0, this.valuesPtr);
            this.values[this.valuesPtr] = value;
        }
        return this.valuesPtr;
    }

    public void rehash() {
        boolean needRehash;
        do {
            needRehash = false;
            Object[] oldValues = this.values;
            this.values = new Object[this.keys.length];
            this.valuesPtr = -1;
            int[][] oldEntries = this.entries;
            int entriesLength = this.entries.length * 2;
            this.entries = new int[entriesLength][];
            int i = entriesLength;
            while (--i >= 0) {
                this.entries[i] = new int[21];
                this.entries[i][0] = 1;
            }
            i = oldEntries.length;
            while (--i >= 0) {
                int[] old_iValues = oldEntries[i];
                int j = old_iValues[0];
                while (--j >= 1) {
                    int keyAsInt;
                    int key;
                    int hash;
                    int[] ivalues;
                    int length;
                    if ((length = (ivalues = this.entries[hash = this.hashValue(key = this.keys[keyAsInt = old_iValues[--j]])])[0]) == ivalues.length) {
                        needRehash = true;
                        int[] tmp = new int[length + 2];
                        System.arraycopy(ivalues, 0, tmp, 0, length);
                        ivalues = tmp;
                        this.entries[hash] = tmp;
                    }
                    ivalues[length] = keyAsInt;
                    ivalues[length + 1] = this.newIndexForValue(oldValues[old_iValues[j + 1]]);
                    ivalues[0] = ivalues[0] + 2;
                }
            }
        } while (needRehash);
    }

    public String toString() {
        int[][] lentries = this.entries;
        int[] lkeys = this.keys;
        Object[] lvalues = this.values;
        StringBuffer result = new StringBuffer();
        result.append("{ ");
        int l = lentries.length;
        while (--l > 0) {
            int[] ivalues = lentries[l];
            int c = ivalues[0];
            while (--c > 0) {
                if (ivalues[c] >= 0) {
                    result.append(lkeys[ivalues[c - 1]]).append('=').append(lvalues[ivalues[c]] == null ? "null" : lvalues[ivalues[c]].toString()).append(", ");
                }
                --c;
            }
        }
        result.append('}');
        return result.toString();
    }

    public void valuesToArray(Object[] array) {
        this.valuesToArray(array, 0);
    }

    public void valuesToArray(Object[] array, int index) {
        System.arraycopy(this.values, 0, array, index, this.valuesPtr + 1);
    }

    public int nbValues() {
        return this.valuesPtr + 1;
    }
}

