/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

public class IntToIntTable {
    private int[][] entries;
    private int entriesLength;
    private static final int Threshold = 21;

    public IntToIntTable() {
        this(50);
    }

    public IntToIntTable(int firstSize) {
        this.entries = new int[firstSize][];
        this.entriesLength = this.entries.length;
        int i = firstSize;
        while (--i >= 0) {
            this.entries[i] = new int[21];
            this.entries[i][0] = 1;
        }
    }

    public int at(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.entriesLength;
        int[] values = this.entries[hash];
        int i = values[0];
        while (--i >= 1) {
            if (values[--i] != key) continue;
            return values[i + 1];
        }
        return 0;
    }

    public void atPut(int key, int value) {
        int length;
        if (value == 0) {
            return;
        }
        int hash = (key & Integer.MAX_VALUE) % this.entriesLength;
        int[] values = this.entries[hash];
        int i = length = values[0];
        while (--i >= 1) {
            if (values[--i] != key) continue;
            values[i + 1] = value;
            return;
        }
        if (length == 21) {
            this.rehash();
            this.atPut(key, value);
            return;
        }
        values[length] = key;
        values[length + 1] = value;
        values[0] = values[0] + 2;
    }

    public void grabKeys(int[] keysHolder) {
        int length = keysHolder.length;
        int keyPtr = -1;
        int i = this.entries.length;
        while (--i >= 0) {
            int[] values = this.entries[i];
            int j = values[0];
            while (--j >= 1) {
                if (++keyPtr == length) {
                    return;
                }
                keysHolder[keyPtr] = values[--j];
            }
        }
    }

    public int[] keys() {
        int[] keys = new int[100];
        int keyPtr = 0;
        int i = this.entries.length;
        while (--i >= 0) {
            int[] values = this.entries[i];
            int j = values[0];
            while (--j >= 1) {
                if (keys.length == keyPtr) {
                    int[] nArray = keys;
                    keys = new int[keyPtr + keyPtr];
                    System.arraycopy(nArray, 0, keys, 0, keyPtr);
                }
                keys[keyPtr++] = values[--j];
            }
        }
        int[] nArray = keys;
        keys = new int[keyPtr];
        System.arraycopy(nArray, 0, keys, 0, keyPtr);
        return keys;
    }

    public int numberOfEntries() {
        int size = 0;
        int i = this.entries.length;
        while (--i >= 0) {
            size += (this.entries[i][0] - 1) / 2;
        }
        return size;
    }

    public void rehash() {
        boolean needRehash;
        do {
            needRehash = false;
            int[][] oldEntries = this.entries;
            this.entriesLength = this.entries.length * 2;
            this.entries = new int[this.entriesLength][];
            int i = this.entriesLength;
            while (--i >= 0) {
                this.entries[i] = new int[21];
                this.entries[i][0] = 1;
            }
            i = oldEntries.length;
            while (--i >= 0) {
                int[] oldValues = oldEntries[i];
                int j = oldValues[0];
                while (--j >= 1) {
                    int key;
                    int hash;
                    int[] values;
                    int length;
                    if ((length = (values = this.entries[hash = ((key = oldValues[--j]) & Integer.MAX_VALUE) % this.entriesLength])[0]) == values.length) {
                        needRehash = true;
                        int[] tmp = new int[length + 2];
                        System.arraycopy(values, 0, tmp, 0, length);
                        values = tmp;
                        this.entries[hash] = tmp;
                    }
                    values[length] = key;
                    values[length + 1] = oldValues[j + 1];
                    values[0] = values[0] + 2;
                }
            }
        } while (needRehash);
    }

    public int[] values() {
        int[] values = new int[100];
        int valuePtr = 0;
        int i = this.entries.length;
        while (--i >= 0) {
            int[] kvalues = this.entries[i];
            int j = kvalues[0];
            while (--j >= 1) {
                if (values.length == valuePtr) {
                    int[] nArray = values;
                    values = new int[valuePtr + valuePtr];
                    System.arraycopy(nArray, 0, values, 0, valuePtr);
                }
                values[valuePtr++] = kvalues[--j + 1];
            }
        }
        int[] nArray = values;
        values = new int[valuePtr];
        System.arraycopy(nArray, 0, values, 0, valuePtr);
        return values;
    }
}

