/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

import com.militsa.tools.ObjectToObjectTable;
import com.militsa.tools.Sort;
import com.militsa.tools.graphsupport.Arc;
import com.militsa.tools.graphsupport.GraphException;
import com.militsa.tools.graphsupport.Node;

public class Graph {
    public Node[] nodes = new Node[100];
    public int nodesPtr = -1;
    public Arc[] arcs = new Arc[100];
    public int arcsPtr = -1;
    private static final int DefaultSize = 100;
    private static final Object done = new Object();

    public int[] colors() {
        int[] colors = new int[this.nodesPtr + 1];
        Node[][] neighbourgs = new Node[this.nodesPtr + 1][];
        int i = colors.length;
        while (--i >= 0) {
            colors[i] = -1;
            neighbourgs[i] = this.nodes[i].neighbourgs();
        }
        for (int nb = this.nodesPtr + 1; nb > 0; --nb) {
            int color;
            int current;
            int i2;
            int[] nodesIndexes = new int[nb];
            int[] colorsDegres = new int[nb];
            int ptr = -1;
            int i3 = this.nodesPtr + 1;
            while (--i3 >= 0) {
                if (colors[i3] != -1) continue;
                nodesIndexes[++ptr] = i3;
                Node[] arounds = neighbourgs[i3];
                int colorDegre = 0;
                int ai = arounds.length;
                while (--ai >= 0) {
                    if (colors[arounds[ai].graphPosition] == -1) continue;
                    ++colorDegre;
                }
                colorsDegres[ptr] = colorDegre;
            }
            Sort.sort(colorsDegres, nodesIndexes);
            int max = colorsDegres[nb - 1];
            int iMax = nb;
            while (--iMax >= 0 && colorsDegres[iMax] == max) {
            }
            if (iMax + 1 != nb - 1) {
                int size = nb - iMax - 1;
                int[] indexes = new int[size];
                int[] degres = new int[size];
                ptr = -1;
                i2 = nb;
                while (--i2 > iMax) {
                    indexes[++ptr] = nodesIndexes[i2];
                    degres[ptr] = this.nodes[nodesIndexes[i2]].degre();
                }
                Sort.sort(degres, indexes);
                current = indexes[size - 1];
            } else {
                current = nodesIndexes[nb - 1];
            }
            Node[] arounds = neighbourgs[current];
            int[] aroundsColors = new int[arounds.length];
            int i4 = arounds.length;
            while (--i4 >= 0) {
                aroundsColors[i4] = colors[arounds[i4].graphPosition];
            }
            Sort.sort(aroundsColors);
            i2 = -1;
            int length = arounds.length;
            while (++i2 < length && aroundsColors[i2] == -1) {
            }
            if (i2 == length) {
                color = 0;
            } else if (aroundsColors[i2] != 0) {
                color = 0;
            } else {
                color = 1;
                for (int j = i2; j < length && aroundsColors[j] <= color; ++j) {
                    if (aroundsColors[j] != color) continue;
                    ++color;
                }
            }
            colors[current] = color;
        }
        return colors;
    }

    public void peemoller(int[] clique, int q) {
    }

    public Arc deconnectArc(Arc arc) {
        arc.source.removeSource(arc);
        arc.destination.removeDestination(arc);
        if (arc.bidirectional) {
            arc.source.removeDestination(arc);
            arc.destination.removeSource(arc);
        }
        return arc;
    }

    public Arc[] deconnectNode(Node node) {
        int ptr = -1;
        Arc[] deconnectedArcs = new Arc[node.degre()];
        Arc[] list = node.sources;
        int i = node.sourcesPtr;
        while (--i >= 0) {
            deconnectedArcs[++ptr] = this.deconnectArc(list[i]);
        }
        list = node.destinations;
        i = node.destinationsPtr;
        while (--i >= 0) {
            deconnectedArcs[++ptr] = this.deconnectArc(list[i]);
        }
        return deconnectedArcs;
    }

    public void reconnectNode(Node node) {
        if (node.isDead()) {
            throw new GraphException();
        }
    }

    public void reconnectArc(Arc arc) {
        if (arc.isDead() || arc.source.isDead() || arc.destination.isDead()) {
            throw new GraphException();
        }
        this.addArcBetween(arc.source, arc.destination, arc.bidirectional);
    }

    public Node[] copyNodes() {
        int length = this.nodesPtr + 1;
        Node[] result = new Node[length];
        System.arraycopy(this.nodes, 0, result, 0, length);
        return result;
    }

    public Arc[] copyArcs() {
        int length = this.arcsPtr + 1;
        Arc[] result = new Arc[length];
        System.arraycopy(this.arcs, 0, result, 0, length);
        return result;
    }

    public void addArcBetween(Node source, Node destination) {
        this.addArcBetween(source, destination, false);
    }

    public void addArcBetween(Node source, Node destination, boolean biDirectional) {
        this.addArc(this.newArc(source, destination, biDirectional));
    }

    public void addArc(Arc arc) {
        if (arc.isDead()) {
            this.insertArc(arc);
        }
        arc.source.addSource(arc);
        arc.destination.addDestination(arc);
        if (arc.bidirectional) {
            arc.destination.addSource(arc);
            arc.source.addDestination(arc);
        }
    }

    public Arc addArcOnceBetween(Node source, Node destination, boolean biDirectional) {
        Arc[] arcs = source.sources;
        if (arcs != null) {
            int i = source.sourcesPtr + 1;
            while (--i >= 0) {
                Arc arc = arcs[i];
                if ((arc.source != source || arc.destination != destination) && (!biDirectional || arc.source != destination || arc.destination != source)) continue;
                return arc;
            }
        }
        Arc arc = this.newArc(source, destination, biDirectional);
        this.addArc(arc);
        return arc;
    }

    public int weightBetween(Node source, Node destination, boolean biDirectional) {
        Arc[] arcs = source.sources;
        if (arcs != null) {
            int i = source.sourcesPtr + 1;
            while (--i >= 0) {
                Arc arc = arcs[i];
                if ((arc.source != source || arc.destination != destination) && (!biDirectional || arc.source != destination || arc.destination != source)) continue;
                return arc.weight;
            }
        }
        return 0;
    }

    public void addNode(Node node) {
        if (node.isDead()) {
            this.insertNode(node);
        }
    }

    public void removeNode(Node node) {
        Arc[] sources = node.sources;
        int i = node.sourcesPtr;
        while (--i >= 0) {
            this.removeArc(sources[i]);
        }
        Arc[] destinations = node.destinations;
        int i2 = node.destinationsPtr;
        while (--i2 >= 0) {
            this.removeArc(destinations[i2]);
        }
        this.deleteNode(node);
    }

    public void removeArc(Arc arc) {
        arc.source.removeSource(arc);
        arc.destination.removeDestination(arc);
        if (arc.bidirectional) {
            arc.source.removeDestination(arc);
            arc.destination.removeSource(arc);
        }
        this.deleteArc(arc);
    }

    public Arc newArc(Node source, Node destination) {
        return new Arc(source, destination, false);
    }

    public Arc newArc(Node source, Node destination, boolean bidirectional) {
        return new Arc(source, destination, bidirectional);
    }

    public Node newNode() {
        return new Node();
    }

    public Node newNode(Object generic) {
        Node node = new Node();
        node.generic = generic;
        return node;
    }

    public Node newNode(int generic) {
        Node node = new Node();
        node.weight = generic;
        return node;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean printHeader) {
        StringBuffer stream = new StringBuffer();
        if (printHeader) {
            stream.append(super.toString());
            stream.append("\n");
        }
        ObjectToObjectTable allreadyPrinted = new ObjectToObjectTable();
        int i = -1;
        while (++i <= this.nodesPtr) {
            if (allreadyPrinted.at(this.nodes[i]) == done) continue;
            this.toString(this.nodes[i], allreadyPrinted, stream, 0);
            stream.append("\n");
        }
        return stream.toString();
    }

    public void toString(Node node, ObjectToObjectTable dones, StringBuffer stream, int tab) {
        this.smallPrint(stream, node.toString());
        if (dones.at(node) == done) {
            return;
        }
        dones.atPut(node, done);
        Arc[] arcs = node.sources;
        int arcsLength = node.sourcesPtr + 1;
        int i = -1;
        while (++i < arcsLength) {
            Arc arc = arcs[i];
            if (arc.source != node) continue;
            stream.append("\n");
            int t = tab + 1;
            while (--t >= 0) {
                stream.append("    ");
            }
            if (arc.bidirectional) {
                stream.append("<---");
            } else {
                stream.append("----");
            }
            this.smallPrint(stream, arc.toString());
            stream.append("--->");
            this.toString(arc.destination, dones, stream, tab + 1);
        }
    }

    private void smallPrint(StringBuffer stream, String s) {
        int length = s.length() > 25 ? 25 : s.length();
        int i = -1;
        while (++i < length) {
            char c = s.charAt(i);
            if (c == '\n' || c == '\t' || c == '\r') continue;
            stream.append(c);
        }
    }

    private void insertArc(Arc arc) {
        try {
            this.arcs[++this.arcsPtr] = arc;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.arcs = new Arc[this.arcsPtr + this.arcsPtr];
            System.arraycopy(this.arcs, 0, this.arcs, 0, this.arcsPtr);
            this.arcs[this.arcsPtr] = arc;
        }
        arc.graphPosition = this.arcsPtr;
    }

    private void insertNode(Node node) {
        try {
            this.nodes[++this.nodesPtr] = node;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.nodes = new Node[this.nodesPtr + this.nodesPtr];
            System.arraycopy(this.nodes, 0, this.nodes, 0, this.nodesPtr);
            this.nodes[this.nodesPtr] = node;
        }
        node.graphPosition = this.nodesPtr;
    }

    private void deleteNode(Node node) {
        int index = node.graphPosition;
        System.arraycopy(this.nodes, index + 1, this.nodes, index, this.nodesPtr - index);
        int i = this.nodesPtr;
        while (--i >= index) {
            this.nodes[i].graphPosition = i;
        }
        --this.nodesPtr;
        node.initialize();
    }

    private void deleteArc(Arc arc) {
        int index = arc.graphPosition;
        System.arraycopy(this.arcs, index + 1, this.arcs, index, this.arcsPtr - index);
        int i = this.arcsPtr;
        while (--i >= index) {
            this.arcs[i].graphPosition = i;
        }
        --this.arcsPtr;
        arc.initialize();
    }

    public static void example() {
        Graph graph = new Graph();
        Node s = graph.newNode();
        graph.addNode(s);
        Node d = graph.newNode();
        graph.addNode(d);
        graph.addArcBetween(s, d);
        graph.addArcBetween(d, s);
        graph.addArcBetween(s, d, true);
        System.out.println(graph);
        graph = new Graph();
        Node n0 = graph.newNode();
        graph.addNode(n0);
        Node n1 = graph.newNode();
        graph.addNode(n1);
        Node n2 = graph.newNode();
        graph.addNode(n2);
        Node n3 = graph.newNode();
        graph.addNode(n3);
        Node n4 = graph.newNode();
        graph.addNode(n4);
        graph.addArcBetween(n0, n1, true);
        graph.addArcBetween(n0, n2, true);
        graph.addArcBetween(n2, n3, true);
        graph.addArcBetween(n1, n3, true);
        graph.addArcBetween(n0, n3, true);
        graph.addArcBetween(n1, n4, true);
        graph.addArcBetween(n3, n4, true);
        System.out.println("\n*******the graph********");
        System.out.println(graph);
        System.out.println("\n*******and its colors********");
        int[] colors = graph.colors();
        int ni = graph.nodesPtr + 1;
        while (--ni >= 0) {
            System.out.print("\n" + graph.nodes[ni] + " : " + colors[ni]);
        }
        graph = new Graph();
        n0 = graph.newNode();
        graph.addNode(n0);
        n1 = graph.newNode();
        graph.addNode(n1);
        n2 = graph.newNode();
        graph.addNode(n2);
        n3 = graph.newNode();
        graph.addNode(n3);
        n4 = graph.newNode();
        graph.addNode(n4);
        Node n5 = graph.newNode();
        graph.addNode(n5);
        Node n6 = graph.newNode();
        graph.addNode(n6);
        Node n7 = graph.newNode();
        graph.addNode(n7);
        Node n8 = graph.newNode();
        graph.addNode(n8);
        graph.addArcBetween(n0, n1, true);
        graph.addArcBetween(n0, n2, true);
        graph.addArcBetween(n2, n1, true);
        graph.addArcBetween(n2, n3, true);
        graph.addArcBetween(n1, n3, true);
        graph.addArcBetween(n1, n8, true);
        graph.addArcBetween(n1, n7, true);
        graph.addArcBetween(n3, n7, true);
        graph.addArcBetween(n5, n7, true);
        graph.addArcBetween(n5, n3, true);
        graph.addArcBetween(n5, n6, true);
        graph.addArcBetween(n6, n8, true);
        graph.addArcBetween(n6, n4, true);
        graph.addArcBetween(n3, n8, true);
        System.out.println("\n*******the graph********");
        System.out.println(graph);
        System.out.println("\n*******and its colors********");
        int[] colors2 = graph.colors();
        int ni2 = graph.nodesPtr + 1;
        while (--ni2 >= 0) {
            System.out.print("\n" + graph.nodes[ni2] + " : " + colors2[ni2]);
        }
        graph = new Graph();
        int i = 25;
        while (--i >= 0) {
            graph.addNode(graph.newNode());
        }
        boolean mono = false;
        i = graph.nodesPtr + 1;
        while (--i >= 0) {
            for (int j = 0; j <= graph.nodesPtr; ++j) {
                graph.addArcBetween(graph.nodes[i], graph.nodes[j], mono);
            }
        }
        System.out.println("\n*******the graph********");
        System.out.println(graph);
        System.out.println("\n*******and its colors********");
        int[] colors3 = graph.colors();
        int ni3 = graph.nodesPtr + 1;
        while (--ni3 >= 0) {
            System.out.print("\n" + graph.nodes[ni3] + " : " + colors3[ni3]);
        }
    }
}

