/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

import com.militsa.tools.BufferClosedException;
import com.militsa.tools.BufferReadTimedOutException;

public class ExtensibleByteBufferQueue {
    private Object monitor;
    private byte[] readBuffer;
    private int lastReadPtr;
    private int lastAddedPtr;
    private boolean closed;

    public ExtensibleByteBufferQueue(int defaultSize) {
        this.readBuffer = new byte[defaultSize];
        this.monitor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addByte(byte byteValue) {
        Object object = this.monitor;
        synchronized (object) {
            int nextPtr = this.lastAddedPtr + 1;
            if (nextPtr == this.readBuffer.length) {
                nextPtr = 0;
            }
            if (nextPtr == this.lastReadPtr) {
                byte[] newQueue = new byte[this.readBuffer.length * 2];
                if (this.lastAddedPtr > this.lastReadPtr) {
                    if (this.lastAddedPtr != this.readBuffer.length - 1 || this.lastReadPtr != 0) {
                        throw new RuntimeException();
                    }
                    System.arraycopy(this.readBuffer, 1, newQueue, 1, this.readBuffer.length - 1);
                    nextPtr = this.lastAddedPtr + 1;
                } else {
                    int length = this.readBuffer.length - (this.lastReadPtr + 1);
                    System.arraycopy(this.readBuffer, this.lastReadPtr + 1, newQueue, 1, length);
                    System.arraycopy(this.readBuffer, 0, newQueue, 1 + length, this.lastAddedPtr + 1);
                    this.lastReadPtr = 0;
                    nextPtr = this.readBuffer.length;
                }
                this.readBuffer = newQueue;
            }
            this.lastAddedPtr = nextPtr;
            this.readBuffer[this.lastAddedPtr] = byteValue;
            this.monitor.notify();
        }
    }

    public byte read() throws BufferClosedException {
        try {
            return this.read(0);
        }
        catch (BufferReadTimedOutException e) {
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte read(int timeout) throws BufferClosedException, BufferReadTimedOutException {
        Object object = this.monitor;
        synchronized (object) {
            int nextPtr;
            if (this.lastAddedPtr == this.lastReadPtr) {
                if (this.closed) {
                    throw new BufferClosedException();
                }
                try {
                    this.monitor.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
                if (this.closed) {
                    throw new BufferClosedException();
                }
                if (this.lastAddedPtr == this.lastReadPtr) {
                    throw new BufferReadTimedOutException();
                }
            }
            if ((nextPtr = this.lastReadPtr + 1) == this.readBuffer.length) {
                nextPtr = 0;
            }
            this.lastReadPtr = nextPtr;
            return this.readBuffer[this.lastReadPtr];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean available() {
        Object object = this.monitor;
        synchronized (object) {
            return this.lastAddedPtr != this.lastReadPtr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.monitor;
        synchronized (object) {
            this.closed = true;
            this.monitor.notify();
        }
    }
}

