/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

public final class BitManipulation {
    private BitManipulation() {
    }

    public static long convertEndian(long l) {
        return l << 56 & (l & 0xFF00L) << 40 & (l & 0xFF0000L) << 24 & (l & 0xFFFFFFFFFF000000L) << 8 & (l & 0xFF00000000L) >>> 8 & (l & 0xFF0000000000L) >>> 24 & (l & 0xFF000000000000L) >>> 40 & l >>> 56;
    }

    public static int convertEndian(int i) {
        return i << 24 & (i & 0xFF) << 8 & (i & 0xFF0000) >>> 8 & i >>> 24;
    }

    public static short convertEndian(short s) {
        return (short)(s >>> 8 & s << 8);
    }

    public static char convertEndian(char c) {
        return (char)(c >>> 8 & c << 8);
    }

    public static double convertEndian(double d) {
        long bits = Double.doubleToLongBits(d);
        return Double.longBitsToDouble(bits << 56 & (bits & 0xFF00L) << 40 & (bits & 0xFF0000L) << 24 & (bits & 0xFFFFFFFFFF000000L) << 8 & (bits & 0xFF00000000L) >>> 8 & (bits & 0xFF0000000000L) >>> 24 & (bits & 0xFF000000000000L) >>> 40 & bits >>> 56);
    }

    public static float convertEndian(float f) {
        int bits = Float.floatToIntBits(f);
        return Float.intBitsToFloat(bits << 24 & (bits & 0xFF) << 8 & (bits & 0xFF0000) >>> 8 & bits >>> 24);
    }

    public static final int getInt(byte[] buf, int off, boolean isBigEndian) {
        byte i3 = buf[off];
        byte i2 = buf[++off];
        byte i1 = buf[++off];
        byte i0 = buf[++off];
        if (isBigEndian) {
            return i3 << 24 | (i2 & 0xFF) << 16 | (i1 & 0xFF) << 8 | i0 & 0xFF;
        }
        return i0 << 24 | (i1 & 0xFF) << 16 | (i2 & 0xFF) << 8 | i3 & 0xFF;
    }

    public static short getShort(byte[] buf, int off, boolean isBigEndian) {
        byte i1 = buf[off];
        byte i0 = buf[++off];
        if (isBigEndian) {
            return (short)((i1 & 0xFF) << 8 | i0 & 0xFF);
        }
        return (short)(i0 << 8 | i1 & 0xFF);
    }

    public static char getChar(byte[] buf, int off, boolean isBigEndian) {
        return (char)BitManipulation.getShort(buf, off, isBigEndian);
    }

    public static final long getLong(byte[] buf, int off, boolean isBigEndian) {
        int i0 = BitManipulation.getInt(buf, off, isBigEndian);
        int i1 = BitManipulation.getInt(buf, off + 4, isBigEndian);
        if (isBigEndian) {
            return (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
        }
        return (long)i1 << 32 | (long)i0 & 0xFFFFFFFFL;
    }

    public static final float getFloat(byte[] buf, int off, boolean isBigEndian) {
        return Float.intBitsToFloat(BitManipulation.getInt(buf, off, isBigEndian));
    }

    public static final double getDouble(byte[] buf, int off, boolean isBigEndian) {
        int i0 = BitManipulation.getInt(buf, off, isBigEndian);
        int i1 = BitManipulation.getInt(buf, off + 4, isBigEndian);
        if (isBigEndian) {
            return Double.longBitsToDouble((long)i0 << 32 | (long)i1 & 0xFFFFFFFFFFFFFFFFL);
        }
        return Double.longBitsToDouble((long)i1 << 32 | (long)i0 & 0xFFFFFFFFFFFFFFFFL);
    }

    public static final void putShort(byte[] buf, int off, boolean isBigEndian, short value) {
        short low = value;
        int high = value >>> 8;
        if (isBigEndian) {
            buf[off] = (byte)high;
            buf[++off] = (byte)low;
        } else {
            buf[off] = (byte)low;
            buf[++off] = (byte)high;
        }
    }

    public static void putChar(byte[] array, int index, boolean bigEndian, char val) {
        BitManipulation.putShort(array, index, bigEndian, (short)val);
    }

    public static final void putInt(byte[] buf, int off, boolean isBigEndian, int value) {
        int i0 = value;
        int i1 = value >>> 8;
        int i2 = value >>> 16;
        int i3 = value >>> 24;
        if (isBigEndian) {
            buf[off] = (byte)i3;
            buf[++off] = (byte)i2;
            buf[++off] = (byte)i1;
            buf[++off] = (byte)i0;
        } else {
            buf[off] = (byte)i0;
            buf[++off] = (byte)i1;
            buf[++off] = (byte)i2;
            buf[++off] = (byte)i3;
        }
    }

    public static final void putLong(byte[] buf, int off, boolean isBigEndian, long value) {
        int high = (int)(value >>> 32);
        int low = (int)value;
        BitManipulation.putInt(buf, off, isBigEndian, isBigEndian ? high : low);
        BitManipulation.putInt(buf, off + 4, isBigEndian, isBigEndian ? low : high);
    }

    public static void putFloat(byte[] array, int index, boolean bigEndian, float value) {
        BitManipulation.putInt(array, index, bigEndian, Float.floatToIntBits(value));
    }

    public static void putDouble(byte[] array, int index, boolean bigEndian, double val) {
        BitManipulation.putLong(array, index, bigEndian, Double.doubleToLongBits(val));
    }

    public static int u1(byte[] bytes, int ptr) {
        return bytes[ptr] & 0xFF;
    }

    public static int writeU1(byte[] bytes, int ptr, int value) {
        bytes[ptr] = (byte)value;
        return bytes[ptr];
    }

    public static int u2(byte[] bytes, int ptr, boolean lsbAndNotMsb) {
        if (lsbAndNotMsb) {
            return bytes[ptr++] & 0xFF | (bytes[ptr++] & 0xFF) << 8;
        }
        return (bytes[ptr++] & 0xFF) << 8 | bytes[ptr++] & 0xFF;
    }

    public static int u4(byte[] bytes, int ptr, boolean lsbAndNotMsb) {
        if (lsbAndNotMsb) {
            return bytes[ptr++] & 0xFF | (bytes[ptr++] & 0xFF) << 8 | (bytes[ptr++] & 0xFF) << 16 | (bytes[ptr] & 0xFF) << 24;
        }
        return (bytes[ptr++] & 0xFF) << 24 | (bytes[ptr++] & 0xFF) << 16 | (bytes[ptr++] & 0xFF) << 8 | bytes[ptr] & 0xFF;
    }

    public static long u8(byte[] bytes, int ptr, boolean lsbAndNotMsb) {
        if (lsbAndNotMsb) {
            return (long)bytes[ptr++] & 0xFFL | ((long)bytes[ptr++] & 0xFFL) << 8 | ((long)bytes[ptr++] & 0xFFL) << 16 | ((long)bytes[ptr] & 0xFFL) << 24 | ((long)bytes[ptr] & 0xFFL) << 32 | ((long)bytes[ptr] & 0xFFL) << 40 | ((long)bytes[ptr] & 0xFFL) << 48 | ((long)bytes[ptr] & 0xFFL) << 56;
        }
        return ((long)bytes[ptr++] & 0xFFL) << 56 | ((long)bytes[ptr++] & 0xFFL) << 48 | ((long)bytes[ptr++] & 0xFFL) << 40 | ((long)bytes[ptr++] & 0xFFL) << 32 | ((long)bytes[ptr++] & 0xFFL) << 24 | ((long)bytes[ptr++] & 0xFFL) << 16 | ((long)bytes[ptr++] & 0xFFL) << 8 | (long)bytes[ptr] & 0xFFL;
    }

    public static long uN(byte[] bytes, int ptr, int size, boolean lsbAndNotMsb) {
        long value = 0L;
        if (lsbAndNotMsb) {
            int i = -1;
            while (++i < size) {
                value |= ((long)bytes[ptr++] & 0xFFL) << i * 8;
            }
        } else {
            int i = size;
            while (--i >= 0) {
                value |= ((long)bytes[ptr++] & 0xFFL) << i * 8;
            }
        }
        return value;
    }

    public static void writeU4(byte[] bytes, int ptr, boolean lsbAndNotMsb, int u4) {
        if (lsbAndNotMsb) {
            bytes[ptr++] = (byte)u4;
            bytes[ptr++] = (byte)(u4 >>> 8);
            bytes[ptr++] = (byte)(u4 >>> 16);
            bytes[ptr++] = (byte)(u4 >>> 24);
        } else {
            bytes[ptr++] = (byte)(u4 >>> 24);
            bytes[ptr++] = (byte)(u4 >>> 16);
            bytes[ptr++] = (byte)(u4 >>> 8);
            bytes[ptr++] = (byte)u4;
        }
    }

    public static void writeU2(byte[] bytes, int ptr, boolean lsbAndNotMsb, int u2) {
        if (lsbAndNotMsb) {
            bytes[ptr++] = (byte)u2;
            bytes[ptr++] = (byte)(u2 >>> 8);
        } else {
            bytes[ptr++] = (byte)(u2 >>> 8);
            bytes[ptr++] = (byte)u2;
        }
    }

    public static void writeUN(byte[] bytes, int ptr, boolean lsbAndNotMsb, long uN, int size) {
        if (lsbAndNotMsb) {
            int i = -1;
            while (++i < size) {
                bytes[ptr++] = (byte)(uN >>> i * 8);
            }
        } else {
            int i = size;
            while (--i >= 0) {
                bytes[ptr++] = (byte)(uN >>> i * 8);
            }
        }
    }

    public static long u32(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static final int putChars(byte[] bytes, int off, boolean isBigEndian, char[] values) {
        int nbChars = values.length;
        BitManipulation.putInt(bytes, off, isBigEndian, nbChars);
        off += 4;
        for (int j = 0; j < nbChars; ++j) {
            BitManipulation.putChar(bytes, off, isBigEndian, values[j]);
            off += 2;
        }
        return off;
    }

    public static final char[] getChars(byte[] bytes, int off, boolean isBigEndian) {
        int nbChars = BitManipulation.getInt(bytes, off, isBigEndian);
        off += 4;
        char[] chars = new char[nbChars];
        for (int j = 0; j < nbChars; ++j) {
            chars[j] = BitManipulation.getChar(bytes, off, isBigEndian);
            off += 2;
        }
        return chars;
    }
}

