/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

import java.io.FileOutputStream;

public class BinaryFileOutputStream {
    private byte[][] bytesSections;
    private int[] bytesPtrSections;
    private int currentSectionId;
    private byte[] currentSection;
    private int currentSectionPtr;

    public BinaryFileOutputStream(int nbSections) {
        this(nbSections, 5000);
    }

    public BinaryFileOutputStream(int nbSections, int defaultSize) {
        this.bytesSections = new byte[nbSections][];
        this.bytesPtrSections = new int[nbSections];
        int i = nbSections;
        while (--i >= 0) {
            this.bytesSections[i] = new byte[defaultSize];
            this.bytesPtrSections[i] = -1;
        }
        this.currentSectionId = 0;
        this.currentSection = this.bytesSections[0];
        this.currentSectionPtr = this.bytesPtrSections[0];
    }

    public void setDefaultSection(int sectionId) {
        this.bytesSections[this.currentSectionId] = this.currentSection;
        this.bytesPtrSections[this.currentSectionId] = this.currentSectionPtr;
        this.currentSectionId = sectionId;
        this.currentSection = this.bytesSections[sectionId];
        this.currentSectionPtr = this.bytesPtrSections[sectionId];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeIn(String filename) {
        this.bytesSections[this.currentSectionId] = this.currentSection;
        this.bytesPtrSections[this.currentSectionId] = this.currentSectionPtr;
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(filename);
            int nbSections = this.bytesSections.length;
            int i = -1;
            while (++i < nbSections) {
                stream.write(this.bytesSections[i], 0, this.bytesPtrSections[i] + 1);
            }
            stream.flush();
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    public void writeU1(int u1) {
        try {
            this.currentSection[++this.currentSectionPtr] = (byte)u1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.currentSection = new byte[this.currentSectionPtr * 2];
            System.arraycopy(this.currentSection, 0, this.currentSection, 0, this.currentSectionPtr);
            this.currentSection[this.currentSectionPtr] = (byte)u1;
        }
    }

    public void writeU2(int u1) {
        this.writeU1(u1);
        this.writeU1(u1 >>> 8);
    }

    public void writeU3(int u1) {
        this.writeU1(u1);
        this.writeU1(u1 >>> 8);
        this.writeU1(u1 >>> 16);
    }

    public void writeU4(int u1) {
        this.writeU1(u1);
        this.writeU1(u1 >>> 8);
        this.writeU1(u1 >>> 16);
        this.writeU1(u1 >>> 24);
    }

    public void writeU1At(int toPtr, int u1) {
        this.currentSection[toPtr] = (byte)u1;
    }

    public void writeU2At(int toPtr, int u2) {
        this.currentSection[toPtr++] = (byte)u2;
        this.currentSection[toPtr] = (byte)(u2 >>> 8);
    }

    public void writeU4At(int toPtr, int u1) {
        this.writeU1At(toPtr, u1);
        this.writeU1At(toPtr, u1 >>> 8);
        this.writeU1At(toPtr, u1 >>> 16);
        this.writeU1At(toPtr, u1 >>> 24);
    }

    public void append(byte[] data) {
        int length = data.length;
        int i = -1;
        while (++i < length) {
            this.writeU1(data[i] & 0xFF);
        }
    }

    public int reserveBytes(int nbBytes) {
        int index = this.currentSectionPtr + 1;
        try {
            this.currentSection[this.currentSectionPtr += nbBytes] = 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int length = this.currentSection.length;
            this.currentSection = new byte[this.currentSectionPtr * 2];
            System.arraycopy(this.currentSection, 0, this.currentSection, 0, length);
        }
        return index;
    }
}

