/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.signature;

import com.militsa.tools.StateSymbolTable;

public class TypeSignature {
    public static StateSymbolTable Symbols;
    public static final char PACKAGE_SEPARATOR = '/';
    public static final char ARRAY_SYMBOL = '[';
    public static final char ENDTYPE_SYMBOL = ';';
    public static final char BEGINTYPE_SYMBOL = 'L';
    public static char[] JNIBOOLEAN;
    public static char[] JNIBYTE;
    public static char[] JNISHORT;
    public static char[] JNICHAR;
    public static char[] JNIINT;
    public static char[] JNIDOUBLE;
    public static char[] JNIFLOAT;
    public static char[] JNILONG;
    public static char[] JNIVOID;
    public static char[] BOOLEAN;
    public static char[] BYTE;
    public static char[] SHORT;
    public static char[] CHAR;
    public static char[] INT;
    public static char[] DOUBLE;
    public static char[] FLOAT;
    public static char[] LONG;
    public static char[] VOID;
    public char[] packagePart;
    public char[] typeName;
    public int dimension;
    public boolean isBaseType;
    public char[] jniName;

    public TypeSignature(StateSymbolTable symbols) {
        if (symbols != null) {
            TypeSignature.initializeClass(symbols);
        } else if (Symbols == null) {
            symbols = new StateSymbolTable();
            TypeSignature.initializeClass(symbols);
        }
    }

    public boolean sameAs(TypeSignature other) {
        return this.sameAs(other.packagePart, other.typeName, other.dimension);
    }

    public boolean sameAs(char[] jniPackageName, char[] jniTypeName, int dimension) {
        return this.dimension == dimension && this.typeName == jniTypeName && this.packagePart == jniPackageName;
    }

    public static void initializeClass(StateSymbolTable symbols) {
        Symbols = symbols;
        BOOLEAN = symbols.getCharArray(new char[]{'b', 'o', 'o', 'l', 'e', 'a', 'n'}, 0, 7);
        BYTE = symbols.getCharArray(new char[]{'b', 'y', 't', 'e'}, 0, 4);
        SHORT = symbols.getCharArray(new char[]{'s', 'h', 'o', 'r', 't'}, 0, 5);
        CHAR = symbols.getCharArray(new char[]{'c', 'h', 'a', 'r'}, 0, 4);
        INT = symbols.getCharArray(new char[]{'i', 'n', 't'}, 0, 3);
        DOUBLE = symbols.getCharArray(new char[]{'d', 'o', 'u', 'b', 'l', 'e'}, 0, 6);
        FLOAT = symbols.getCharArray(new char[]{'f', 'l', 'o', 'a', 't'}, 0, 5);
        LONG = symbols.getCharArray(new char[]{'l', 'o', 'n', 'g'}, 0, 4);
        VOID = symbols.getCharArray(new char[]{'v', 'o', 'i', 'd'}, 0, 4);
        JNIBOOLEAN = symbols.getCharArray(new char[]{'Z'}, 0, 1);
        JNIBYTE = symbols.getCharArray(new char[]{'B'}, 0, 1);
        JNISHORT = symbols.getCharArray(new char[]{'S'}, 0, 1);
        JNICHAR = symbols.getCharArray(new char[]{'C'}, 0, 1);
        JNIINT = symbols.getCharArray(new char[]{'I'}, 0, 1);
        JNIDOUBLE = symbols.getCharArray(new char[]{'D'}, 0, 1);
        JNIFLOAT = symbols.getCharArray(new char[]{'F'}, 0, 1);
        JNILONG = symbols.getCharArray(new char[]{'J'}, 0, 1);
        JNIVOID = symbols.getCharArray(new char[]{'V'}, 0, 1);
    }

    public TypeSignature initializeFromJniDescription(char[] jniDescription) {
        int charsPtr = -1;
        int charsLen = jniDescription.length;
        this.dimension = 0;
        while (++charsPtr < charsLen && jniDescription[charsPtr] == '[') {
            ++this.dimension;
        }
        if (charsPtr == charsLen) {
            this.typeName = null;
            return this;
        }
        char firstChar = jniDescription[charsPtr];
        this.isBaseType = true;
        if (firstChar == JNIBOOLEAN[0]) {
            this.typeName = JNIBOOLEAN;
        } else if (firstChar == JNIBYTE[0]) {
            this.typeName = JNIBYTE;
        } else if (firstChar == JNISHORT[0]) {
            this.typeName = JNISHORT;
        } else if (firstChar == JNICHAR[0]) {
            this.typeName = JNICHAR;
        } else if (firstChar == JNIINT[0]) {
            this.typeName = JNIINT;
        } else if (firstChar == JNIDOUBLE[0]) {
            this.typeName = JNIDOUBLE;
        } else if (firstChar == JNIFLOAT[0]) {
            this.typeName = JNIFLOAT;
        } else if (firstChar == JNILONG[0]) {
            this.typeName = JNILONG;
        } else if (firstChar == JNIVOID[0]) {
            this.typeName = JNIVOID;
        } else {
            this.isBaseType = false;
            if (firstChar != 'L' || jniDescription[charsLen - 1] != ';') {
                this.typeName = null;
                return this;
            }
            int ptr = charsLen - 1;
            while (--ptr >= 0) {
                if (jniDescription[ptr] != '/') continue;
                this.typeName = Symbols.getCharArray(jniDescription, ptr + 1, charsLen - 1);
                this.packagePart = Symbols.getCharArray(jniDescription, this.dimension + 1, ptr);
                return this;
            }
        }
        return this;
    }

    public String toStringAsUsualDescription() {
        StringBuffer sb = new StringBuffer();
        if (this.typeName == null || this.typeName.length == 0) {
            return "invalid type";
        }
        if (this.isBaseType) {
            if (this.typeName == JNIBOOLEAN) {
                sb.append(BOOLEAN);
            } else if (this.typeName == JNIBYTE) {
                sb.append(BYTE);
            } else if (this.typeName == JNICHAR) {
                sb.append(CHAR);
            } else if (this.typeName == JNIDOUBLE) {
                sb.append(DOUBLE);
            } else if (this.typeName == JNIFLOAT) {
                sb.append(FLOAT);
            } else if (this.typeName == JNIINT) {
                sb.append(INT);
            } else if (this.typeName == JNILONG) {
                sb.append(LONG);
            } else if (this.typeName == JNISHORT) {
                sb.append(SHORT);
            } else if (this.typeName == JNIVOID) {
                sb.append(VOID);
            }
        } else {
            sb.append(this.getPackageNameWithDots());
            if (this.packagePart != null && this.packagePart.length > 0) {
                sb.append('.');
            }
            sb.append(this.typeName);
        }
        int i = this.dimension;
        while (--i >= 0) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public String getUsualTypeName() {
        StringBuffer sb = new StringBuffer();
        if (this.typeName == null || this.typeName.length == 0) {
            return "invalid type";
        }
        if (this.isBaseType) {
            if (this.typeName == JNIBOOLEAN) {
                sb.append(BOOLEAN);
            } else if (this.typeName == JNIBYTE) {
                sb.append(BYTE);
            } else if (this.typeName == JNICHAR) {
                sb.append(CHAR);
            } else if (this.typeName == JNIDOUBLE) {
                sb.append(DOUBLE);
            } else if (this.typeName == JNIFLOAT) {
                sb.append(FLOAT);
            } else if (this.typeName == JNIINT) {
                sb.append(INT);
            } else if (this.typeName == JNILONG) {
                sb.append(LONG);
            } else if (this.typeName == JNISHORT) {
                sb.append(SHORT);
            } else if (this.typeName == JNIVOID) {
                sb.append(VOID);
            }
        } else {
            sb.append(this.typeName);
        }
        int i = this.dimension;
        while (--i >= 0) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public char[] getPackageNameWithDots() {
        char[] packageNameDots = new char[this.packagePart.length];
        int i = this.packagePart.length;
        while (--i >= 0) {
            if (this.packagePart[i] == '/') {
                packageNameDots[i] = 46;
                continue;
            }
            packageNameDots[i] = this.packagePart[i];
        }
        return packageNameDots;
    }

    public TypeSignature initializeFromUsualDescription(String usualTypeDeclaration) {
        int c;
        int i;
        usualTypeDeclaration = usualTypeDeclaration.trim();
        int size = usualTypeDeclaration.length();
        char[] typeChar = usualTypeDeclaration.toCharArray();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!Character.isWhitespace(typeChar[i2])) continue;
            return null;
        }
        int ptrTypeChar = -1;
        char[] jniChar = new char[size];
        int endPack = usualTypeDeclaration.lastIndexOf(46);
        if (endPack == size - 1) {
            return null;
        }
        if (endPack != -1) {
            for (i = 0; i < endPack; ++i) {
                c = typeChar[i];
                jniChar[++ptrTypeChar] = c == 46 ? 47 : c;
            }
            this.packagePart = Symbols.getCharArray(jniChar, 0, ++ptrTypeChar);
            ++i;
        } else {
            this.packagePart = Symbols.getCharArray(new char[0], 0, 0);
        }
        ptrTypeChar = -1;
        while (i < size && (c = typeChar[i]) != 91) {
            jniChar[++ptrTypeChar] = c;
            ++i;
        }
        this.typeName = this.convertClassNameToJNIName(jniChar, 0, ptrTypeChar);
        int dimension = 0;
        boolean mode = false;
        while (i < size) {
            char c2 = typeChar[i];
            if (c2 == '[') {
                ++dimension;
                if (mode) {
                    return null;
                }
                mode = true;
            } else if (c2 == ']') {
                if (mode) {
                    mode = false;
                } else {
                    return null;
                }
            }
            ++i;
        }
        if (mode) {
            return null;
        }
        this.dimension = dimension;
        return this;
    }

    private char[] convertClassNameToJNIName(char[] src, int srcPos, int srcEnd) {
        int length = srcEnd - srcPos + 1;
        src = Symbols.getCharArray(src, srcPos, length);
        this.isBaseType = true;
        if (src == BOOLEAN) {
            return JNIBOOLEAN;
        }
        if (src == BYTE) {
            return JNIBYTE;
        }
        if (src == CHAR) {
            return JNICHAR;
        }
        if (src == SHORT) {
            return JNISHORT;
        }
        if (src == INT) {
            return JNIINT;
        }
        if (src == DOUBLE) {
            return JNIDOUBLE;
        }
        if (src == FLOAT) {
            return JNIFLOAT;
        }
        if (src == LONG) {
            return JNILONG;
        }
        if (src == VOID) {
            return JNIVOID;
        }
        this.isBaseType = false;
        return src;
    }

    public boolean fillJNISignature(StringBuffer sb) {
        for (int i = 0; i < this.dimension; ++i) {
            sb.append('[');
        }
        if (!this.isBaseType) {
            sb.append('L');
        }
        if (this.packagePart == null || this.typeName == null) {
            sb.append("invalid type description");
            return false;
        }
        if (this.packagePart.length != 0) {
            sb.append(this.packagePart);
            sb.append('/');
        }
        sb.append(this.typeName);
        if (!this.isBaseType) {
            sb.append(';');
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.fillJNISignature(sb);
        return sb.toString();
    }

    public char[] getJniName() {
        char[] name;
        int size;
        if (this.jniName != null) {
            return this.jniName;
        }
        StringBuffer sb = new StringBuffer();
        if (this.fillJNISignature(sb)) {
            size = sb.length();
            name = new char[size];
            sb.getChars(0, size, name, 0);
        } else {
            name = new char[]{};
            size = 0;
        }
        this.jniName = Symbols.getCharArray(name, 0, size);
        return this.jniName;
    }

    public char[] getInternalName() {
        if (this.dimension != 0) {
            return this.getJniName();
        }
        StringBuffer sb = new StringBuffer();
        if (this.packagePart.length != 0) {
            sb.append(this.packagePart);
            sb.append('/');
        }
        sb.append(this.typeName);
        char[] name = new char[sb.length()];
        sb.getChars(0, sb.length(), name, 0);
        name = Symbols.getCharArray(name, 0, name.length);
        return name;
    }
}

