/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.signature;

import com.militsa.signature.TypeSignature;
import com.militsa.tools.StateSymbolTable;

public class MethodSignature {
    public TypeSignature declarationType;
    public TypeSignature returnType;
    public char[] methodName;
    public TypeSignature[] argumentsType;
    public char[] jniName;

    public MethodSignature(StateSymbolTable symbols) {
        if (symbols != null) {
            TypeSignature.initializeClass(symbols);
        }
    }

    public void addArgument(TypeSignature type) {
        TypeSignature[] newArgs = this.argumentsType;
        int length = newArgs.length;
        TypeSignature[] typeSignatureArray = newArgs;
        newArgs = new TypeSignature[length + 1];
        System.arraycopy(typeSignatureArray, 0, newArgs, 0, length);
        newArgs[length] = type;
        this.argumentsType = newArgs;
    }

    public boolean sameAs(MethodSignature other) {
        if (this.methodName != other.methodName) {
            return false;
        }
        if (this.declarationType.sameAs(other.declarationType) && this.returnType.sameAs(other.returnType) && this.argumentsType.length == other.argumentsType.length) {
            int i = this.argumentsType.length;
            while (--i >= 0) {
                if (this.argumentsType[i].sameAs(other.argumentsType[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean sameAs(char[] methodName, char[] jniDeclarationType, char[] jniReturnType, char[][] jniArgsType) {
        if (this.methodName != methodName) {
            return false;
        }
        if (this.declarationType.getJniName() != jniDeclarationType || this.returnType.getJniName() != jniReturnType || this.argumentsType.length != jniArgsType.length) {
            return false;
        }
        int i = jniArgsType.length;
        while (--i >= 0) {
            if (this.argumentsType[i].getJniName() == jniArgsType[i]) continue;
            return false;
        }
        return true;
    }

    public TypeSignature initializeTypeDeclarationFrom(String usualTypeDecl) {
        TypeSignature type = new TypeSignature(null);
        this.declarationType = type.initializeFromUsualDescription(usualTypeDecl);
        return this.declarationType;
    }

    public TypeSignature initializeReturnTypeDeclarationFrom(String usualTypeDecl) {
        this.returnType = this.getTypeFrom(usualTypeDecl);
        return this.returnType;
    }

    public TypeSignature[] initializeArgsTypeDeclarationFrom(String usualArgsDecl) {
        String[] arguments = usualArgsDecl.split(",");
        TypeSignature[] argsType = new TypeSignature[arguments.length];
        int ptrArgsType = -1;
        for (int i = 0; i < arguments.length; ++i) {
            String arg = arguments[i];
            if ((arg = arg.trim()).length() == 0) {
                return null;
            }
            TypeSignature type = this.getTypeFrom(arg);
            if (type == null) {
                return null;
            }
            argsType[++ptrArgsType] = type;
        }
        return argsType;
    }

    private TypeSignature getTypeFrom(String usualTypeDecl) {
        TypeSignature type = new TypeSignature(null);
        return type.initializeFromUsualDescription(usualTypeDecl);
    }

    public MethodSignature initializeFromUsualDescription(String usualMethodDeclaration) {
        char c;
        this.jniName = null;
        usualMethodDeclaration = usualMethodDeclaration.trim();
        char[] methodChar = usualMethodDeclaration.toCharArray();
        int size = methodChar.length;
        int ptr = -1;
        while (++ptr < size && !Character.isWhitespace(methodChar[ptr])) {
        }
        if (ptr == size) {
            return null;
        }
        if (this.initializeReturnTypeDeclarationFrom(usualMethodDeclaration.substring(0, ptr)) == null) {
            return null;
        }
        while (++ptr < size && Character.isWhitespace(methodChar[ptr])) {
        }
        if (ptr == size) {
            return null;
        }
        char[] jniChar = new char[size - ptr];
        int ptrJniChar = -1;
        while (ptr < size && (c = methodChar[ptr]) != '(') {
            if (Character.isWhitespace(c)) {
                return null;
            }
            jniChar[++ptrJniChar] = c;
            ++ptr;
        }
        if (ptr == size) {
            return null;
        }
        this.methodName = TypeSignature.Symbols.getCharArray(jniChar, 0, ++ptrJniChar);
        int endArgs = usualMethodDeclaration.indexOf(41, ptr);
        if (endArgs == -1) {
            return null;
        }
        String argstr = usualMethodDeclaration.substring(ptr + 1, endArgs);
        if (ptr + 1 < endArgs) {
            this.argumentsType = this.initializeArgsTypeDeclarationFrom(argstr);
            if (this.argumentsType == null) {
                return null;
            }
        } else {
            this.argumentsType = new TypeSignature[0];
        }
        for (int i = endArgs + 1; i < size; ++i) {
            if (Character.isWhitespace(methodChar[i])) continue;
            return null;
        }
        return this;
    }

    public MethodSignature initializeFromUsualDescription(String usualMethodDeclaration, String typeDeclaration) {
        if (this.initializeTypeDeclarationFrom(typeDeclaration) == null) {
            return null;
        }
        return this.initializeFromUsualDescription(usualMethodDeclaration);
    }

    public MethodSignature initializeFromJniDescription(String jniMethodName, String jniMethodDesc, String jniTypeDeclarationDesc) {
        this.jniName = null;
        jniMethodName = jniMethodName.trim();
        char[] methodName = jniMethodName.toCharArray();
        this.methodName = TypeSignature.Symbols.getCharArray(methodName, 0, methodName.length);
        jniTypeDeclarationDesc = jniTypeDeclarationDesc.trim();
        char[] typeDeclaration = jniTypeDeclarationDesc.toCharArray();
        TypeSignature declType = new TypeSignature(null);
        declType.initializeFromJniDescription(typeDeclaration);
        this.declarationType = declType;
        this.argumentsType = new TypeSignature[0];
        jniMethodDesc = jniMethodDesc.trim();
        char[] methodDesc = jniMethodDesc.toCharArray();
        int ptr = -1;
        int length = methodDesc.length;
        try {
            char current;
            if (methodDesc[++ptr] != '(') {
                return null;
            }
            int noArrayStart = -1;
            int arrayStart = -1;
            while (++ptr < length && (current = methodDesc[ptr]) != ')') {
                if (MethodSignature.isBaseType(current)) {
                    TypeSignature type = new TypeSignature(null);
                    if (arrayStart != -1) {
                        int arrayLength = ptr + 1 - arrayStart;
                        char[] arrayDesc = new char[arrayLength];
                        System.arraycopy(methodDesc, arrayStart, arrayDesc, 0, arrayLength);
                        type.initializeFromJniDescription(arrayDesc);
                        arrayStart = -1;
                    } else {
                        type.initializeFromJniDescription(new char[]{current});
                    }
                    this.addArgument(type);
                    continue;
                }
                if (current == '[') {
                    arrayStart = ptr;
                    continue;
                }
                if (current == 'L') {
                    int start;
                    if (arrayStart != -1) {
                        start = arrayStart;
                        arrayStart = -1;
                    } else {
                        start = ptr;
                    }
                    while (methodDesc[++ptr] != ';') {
                    }
                    TypeSignature type = new TypeSignature(null);
                    int jniDescLength = ptr + 1 - start;
                    char[] argDesc = new char[jniDescLength];
                    System.arraycopy(methodDesc, start, argDesc, 0, jniDescLength);
                    type.initializeFromJniDescription(argDesc);
                    this.addArgument(type);
                    continue;
                }
                return null;
            }
            int start = ++ptr;
            char current2 = methodDesc[ptr];
            if (MethodSignature.isBaseType(current2) || current2 == 'V') {
                if (length != ptr + 1) {
                    return null;
                }
            } else {
                while (methodDesc[ptr] == '[') {
                    ++ptr;
                }
                current2 = methodDesc[ptr];
                if (MethodSignature.isBaseType(current2) ? length != ptr + 1 : current2 != 'L' || methodDesc[length - 1] != ';') {
                    return null;
                }
            }
            TypeSignature returnType = new TypeSignature(null);
            int returnLength = length - start;
            char[] returnDesc = new char[returnLength];
            System.arraycopy(methodDesc, start, returnDesc, 0, returnLength);
            returnType.initializeFromJniDescription(returnDesc);
            this.returnType = returnType;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return this;
    }

    private static boolean isBaseType(char c) {
        return c == 'Z' || c == 'B' || c == 'S' || c == 'C' || c == 'I' || c == 'J' || c == 'F' || c == 'D';
    }

    public boolean fillJNISignature(StringBuffer sb, boolean withTypeDec) {
        if (this.declarationType == null || this.methodName == null || this.argumentsType == null || this.returnType == null) {
            sb.append("invalid method description");
            return false;
        }
        if (withTypeDec) {
            this.declarationType.fillJNISignature(sb);
            sb.append('.');
        }
        return this.fillJNIMethodSignature(sb);
    }

    public boolean fillJNIMethodSignature(StringBuffer sb) {
        if (this.methodName == null) {
            sb.append("invalid method description");
            return false;
        }
        sb.append(this.methodName);
        return this.fillJNIMethodDescription(sb);
    }

    public boolean fillJNIMethodDescription(StringBuffer sb) {
        if (this.argumentsType == null || this.returnType == null) {
            sb.append("invalid method description");
            return false;
        }
        sb.append('(');
        for (int i = 0; i < this.argumentsType.length; ++i) {
            this.argumentsType[i].fillJNISignature(sb);
        }
        sb.append(')');
        this.returnType.fillJNISignature(sb);
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.fillJNISignature(sb, true);
        return sb.toString();
    }

    public char[] getJniMethodDescriptor() {
        char[] name;
        int size;
        if (this.jniName != null) {
            return this.jniName;
        }
        StringBuffer sb = new StringBuffer();
        if (this.fillJNIMethodDescription(sb)) {
            size = sb.length();
            name = new char[size];
            sb.getChars(0, size, name, 0);
        } else {
            name = new char[]{};
            size = 0;
        }
        this.jniName = TypeSignature.Symbols.getCharArray(name, 0, size);
        return this.jniName;
    }

    public String getUsualMethodDeclaration() {
        StringBuffer buffer = new StringBuffer(this.returnType.getUsualTypeName()).append(' ').append(this.methodName).append('(');
        TypeSignature[] args = this.argumentsType;
        int end = args.length - 1;
        int i = -1;
        while (++i < end) {
            buffer.append(args[i].getUsualTypeName()).append(',');
        }
        if (end >= 0) {
            buffer.append(args[end].getUsualTypeName());
        }
        return buffer.append(')').toString();
    }

    public static String getMethodFullyQualifiedName(String typeFullyQualifiedName, String methodName, String methodDescriptor) {
        return new StringBuffer(typeFullyQualifiedName).append('.').append(methodName).append(methodDescriptor).toString();
    }
}

