/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.s19generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class S19Generator {
    public File outputFile;
    public String header;
    public int startingExecutionAddress = 0;
    public int lineLength = 64;
    public byte addressSizeId = (byte)51;
    public byte startingExecSizeId = (byte)55;
    private FileOutputStream outputStm;
    private byte[] beginLine;
    public static final int DEFAULT_LINE_LENGTH = 64;
    public static final byte ADDRESS_32BITS = 51;
    public static final byte ADDRESS_24BITS = 50;
    public static final byte ADDRESS_16BITS = 49;
    public static final byte STARTING_EXEC_ADDRESS_32BITS = 55;
    public static final byte STARTING_EXEC_ADDRESS_24BITS = 56;
    public static final byte STARTING_EXEC_ADDRESS_16BITS = 57;

    public boolean open(File outputFile, String fileDescriptor) throws IOException {
        this.header = fileDescriptor;
        try {
            this.outputStm = new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        if (fileDescriptor != null) {
            this.outputStm.write(this.getHeaderBytes());
            this.outputStm.write(10);
        }
        return true;
    }

    public boolean addFiles(File[] inputFiles, int[] addresses) throws IOException {
        if (inputFiles.length != addresses.length) {
            return false;
        }
        int max = inputFiles.length;
        for (int i = 0; i < max; ++i) {
            if (this.addFile(inputFiles[i], addresses[i])) continue;
            return false;
        }
        return true;
    }

    public void close() throws IOException {
        FileOutputStream outputStm = this.outputStm;
        if (outputStm != null) {
            try {
                this.writeLastLine();
            }
            finally {
                outputStm.flush();
                outputStm.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFile(File inputFile, int address) throws IOException {
        try (FileInputStream inputStm = null;){
            inputStm = new FileInputStream(inputFile);
            FileOutputStream outputStm = this.outputStm;
            byte[] bytes = new byte[this.lineLength];
            int nbRead = inputStm.read(bytes);
            int fixedSize = this.addressSizeId == 50 ? 3 : (this.addressSizeId == 49 ? 2 : 4);
            while (nbRead > 0) {
                outputStm.write(this.getBeginLineBytes());
                byte[] lengthBytes = this.getHexa(nbRead + fixedSize + 1);
                outputStm.write(lengthBytes);
                byte[] addressBytes = this.getHexaAddress(address);
                outputStm.write(addressBytes, 8 - fixedSize * 2, fixedSize * 2);
                address += nbRead;
                int i = -1;
                while (++i < nbRead) {
                    byte b = bytes[i];
                    byte[] outBytes = this.getHexa(b);
                    outputStm.write(outBytes);
                }
                outputStm.write(this.getCheckSum(this.getByteValueOfAscii(lengthBytes), this.getByteValueOfAscii(addressBytes), bytes, nbRead));
                outputStm.write(10);
                nbRead = inputStm.read(bytes);
            }
        }
        return true;
    }

    protected void writeHeader() throws IOException {
        this.outputStm.write(this.getHeaderBytes());
        this.outputStm.write(10);
    }

    protected void writeLastLine() throws IOException {
        this.outputStm.write(new byte[]{83, this.startingExecSizeId});
        int fixedSize = this.startingExecSizeId == 57 ? 2 : (this.startingExecSizeId == 56 ? 3 : 4);
        byte[] lengthBytes = this.getHexa(fixedSize + 1);
        this.outputStm.write(lengthBytes);
        byte[] addressBytes = this.getHexaAddress(this.startingExecutionAddress);
        this.outputStm.write(addressBytes, 8 - fixedSize * 2, fixedSize * 2);
        this.outputStm.write(this.getCheckSum(this.getByteValueOfAscii(lengthBytes), this.getByteValueOfAscii(addressBytes), new byte[0], 0));
        this.outputStm.write(10);
    }

    protected byte[] getHeaderBytes() {
        byte[] begin = new byte[]{83, 48};
        byte[] length = this.getHexa(this.header.length() + 2 + 1);
        byte[] address = new byte[]{48, 48, 48, 48};
        byte[] data = new byte[this.header.length() * 2];
        int i = -1;
        while (++i < this.header.length()) {
            byte[] b = this.getHexa(this.header.charAt(i));
            data[i * 2] = b[0];
            data[i * 2 + 1] = b[1];
        }
        byte[] check = this.getCheckSum(this.getByteValueOfAscii(length), this.getByteValueOfAscii(address), this.getByteValueOfAscii(data), data.length / 2);
        byte[] header = new byte[begin.length + length.length + address.length + data.length + check.length];
        int pos = 0;
        System.arraycopy(begin, 0, header, pos, begin.length);
        System.arraycopy(length, 0, header, pos += begin.length, length.length);
        System.arraycopy(address, 0, header, pos += length.length, address.length);
        System.arraycopy(data, 0, header, pos += address.length, data.length);
        System.arraycopy(check, 0, header, pos += data.length, check.length);
        pos += check.length;
        return header;
    }

    protected byte[] getByteValueOfAscii(byte[] ascii) {
        byte[] values = new byte[ascii.length / 2];
        for (int i = 0; i < ascii.length; i += 2) {
            String s = new String(ascii, i, 2);
            Integer value = Integer.valueOf(s, 16);
            values[i / 2] = value.byteValue();
        }
        return values;
    }

    protected byte[] getCheckSum(byte[] lengthBytes, byte[] addressBytes, byte[] dataBytes, int nbRead) {
        byte[] check = new byte[2];
        int sum = 0;
        int i = lengthBytes.length;
        while (--i >= 0) {
            sum += lengthBytes[i] & 0xFF;
        }
        i = addressBytes.length;
        while (--i >= 0) {
            sum += addressBytes[i] & 0xFF;
        }
        i = nbRead;
        while (--i >= 0) {
            sum += dataBytes[i] & 0xFF;
        }
        sum = ~sum & 0xFF;
        i = 2;
        while (--i >= 0) {
            int rem = (sum & 0xFF) % 16;
            sum /= 16;
            check[i] = this.hexaCharacter(rem);
        }
        return check;
    }

    protected byte[] getHexaAddress(int address) {
        byte[] bytes = new byte[8];
        int i = 8;
        while (--i >= 0) {
            int rem = address % 16;
            address /= 16;
            bytes[i] = this.hexaCharacter(rem);
        }
        return bytes;
    }

    protected byte[] getBeginLineBytes() {
        if (this.beginLine == null) {
            this.beginLine = new byte[]{83, this.addressSizeId};
        }
        return this.beginLine;
    }

    public byte[] getHexa(int b) {
        byte[] bytes = new byte[2];
        if (b < 0) {
            b += 256;
        }
        int rem = b % 16;
        int div = b / 16;
        bytes[0] = this.hexaCharacter(div);
        bytes[1] = this.hexaCharacter(rem);
        return bytes;
    }

    private byte hexaCharacter(int hx) {
        switch (hx) {
            case 0: {
                return 48;
            }
            case 1: {
                return 49;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 51;
            }
            case 4: {
                return 52;
            }
            case 5: {
                return 53;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 56;
            }
            case 9: {
                return 57;
            }
            case 10: {
                return 65;
            }
            case 11: {
                return 66;
            }
            case 12: {
                return 67;
            }
            case 13: {
                return 68;
            }
            case 14: {
                return 69;
            }
            case 15: {
                return 70;
            }
        }
        throw new RuntimeException("Error in byte, value = " + hx);
    }
}

