/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.tools.fpa;

public class FPASupportFloat {
    public static final int MAX_VALUE = 0x7FFFFFFD;
    public static final int MIN_VALUE = 1;
    public static final int POSITIVE_NAN_VALUE = 0x7FFFFFFE;
    public static final int NEGATIVE_NAN_VALUE = -2147352578;
    public static final int NEGATIVE_INFINITY = -2147352577;
    public static final int POSITIVE_INFINITY = Integer.MAX_VALUE;
    public static final int M = 16;
    public static final int N = 16;
    public static final int N_MASK = 65535;
    public static final int M_MASK = -65536;
    public static final int SIGN_MASK = Integer.MIN_VALUE;
    public static final int ZERO = 0;

    public static int IEE754ToFP(float f) {
        int f2l = Float.floatToIntBits(f);
        if (f == Float.MAX_VALUE) {
            return 0x7FFFFFFD;
        }
        if (f == Float.MIN_VALUE) {
            return 1;
        }
        if (f2l == Float.floatToIntBits(Float.POSITIVE_INFINITY)) {
            return Integer.MAX_VALUE;
        }
        if (f2l == Float.floatToIntBits(Float.NEGATIVE_INFINITY)) {
            return -2147352577;
        }
        if (Float.isNaN(f)) {
            return 0x7FFFFFFE;
        }
        float fpaValue = f * 65536.0f + (f >= 0.0f ? 0.5f : -0.5f);
        if (fpaValue < -2.1474836E9f || fpaValue > 2.1474836E9f) {
            throw new ArithmeticException();
        }
        return (int)fpaValue;
    }
}

