/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.tools.fpa;

public class FPASupportDouble {
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final long MIN_VALUE = 1L;
    public static final long POSITIVE_NAN_VALUE = 0x7FFFFFFFFFFFFFFEL;
    public static final long NEGATIVE_NAN_VALUE = -9223372028264841218L;
    public static final long NEGATIVE_INFINITY = -9223372028264841217L;
    public static final long POSITIVE_INFINITY = Long.MAX_VALUE;
    public static final int M = 32;
    public static final int N = 32;
    public static final long N_MASK = 0xFFFFFFFFL;
    public static final long M_MASK = -4294967296L;
    public static final long SIGN_MASK = Long.MIN_VALUE;
    public static final long ZERO = 0L;

    public static long IEE754ToFP(double d) {
        long d2l = Double.doubleToLongBits(d);
        if (d == Double.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        if (d == Double.MIN_VALUE) {
            return 1L;
        }
        if (d2l == Double.doubleToLongBits(Double.POSITIVE_INFINITY)) {
            return Long.MAX_VALUE;
        }
        if (d2l == Double.doubleToLongBits(Double.NEGATIVE_INFINITY)) {
            return -9223372028264841217L;
        }
        if (Double.isNaN(d)) {
            return 0x7FFFFFFFFFFFFFFEL;
        }
        double fpaValue = d * 4.294967296E9 + (d >= 0.0 ? 0.5 : -0.5);
        if (fpaValue < -9.223372036854776E18 || fpaValue > 9.223372036854776E18) {
            throw new ArithmeticException();
        }
        return (long)fpaValue;
    }
}

