/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.project;

import com.is2t.filetools.FileTools;
import java.io.File;

public class ProjectGetter {
    public String error;
    public static final String ERROR_INVALID_PATH = "invalid path";
    public static final String PROJECT_NOT_FOUND = "no project for this path";

    public String getProjectName(String initialPath) {
        String location = this.getProjectLocation(initialPath);
        if (location == null) {
            return null;
        }
        int endIndex = location.lastIndexOf(File.separator);
        if (endIndex == -1 && endIndex + 1 >= location.length()) {
            this.error = PROJECT_NOT_FOUND;
            return null;
        }
        String projectName = location.substring(endIndex + 1, location.length());
        if (projectName.length() == 0) {
            this.error = PROJECT_NOT_FOUND;
            return null;
        }
        return projectName;
    }

    public String getProjectLocation(String path) {
        String location = FileTools.getParentContainingFilename(path, ".project");
        if (location == null) {
            File file = new File(path);
            this.error = !file.exists() || !file.isDirectory() ? ERROR_INVALID_PATH : PROJECT_NOT_FOUND;
        }
        return location;
    }
}

