/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.killprocess;

import com.is2t.killprocess.KillProcessManagerOptions;
import com.is2t.killprocess.Process;
import ist.generic.Options;
import ist.generic.Product;
import ist.generic.error.MilitsaErrorHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class KillProcessManager
extends Product {
    private Process[] processList;

    public abstract Process[] listAllProcess(String var1);

    @Override
    public MilitsaErrorHandler newErrorHandler() {
        return new MilitsaErrorHandler();
    }

    @Override
    public Options newOptions() {
        return new KillProcessManagerOptions();
    }

    public void kill(Process[] process, String processImage, String killCmd) {
        if (process == null) {
            return;
        }
        Process findProcess = null;
        int i = process.length;
        while (--i >= 0) {
            Process currentProc = process[i];
            if (!currentProc.image.equals(processImage)) continue;
            findProcess = currentProc;
        }
        if (findProcess != null) {
            try {
                Runtime.getRuntime().exec(killCmd + " " + findProcess.pid);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void killAll(Process[] process, String processImage, String killCmd) {
        int processSize;
        int i = processSize = process.length;
        while (--i >= 0) {
            Process currentProcess = process[i];
            if (!currentProcess.image.equals(processImage)) continue;
            try {
                Runtime.getRuntime().exec(killCmd + " " + currentProcess.pid);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void killAllWithLookUp(String taskListCmd, String processImage, String killCmd, int lookUpTimeOut, int lookUpTentatives) {
        int processSize;
        this.refreshProcessList(taskListCmd);
        if (!this.isAlive(this.processList, processImage)) {
            System.out.println("[" + killCmd + "] " + processImage + " not found");
            return;
        }
        System.out.println("[" + killCmd + "] " + processImage + " alive");
        int i = processSize = this.processList.length;
        while (--i >= 0) {
            Process currentProcess = this.processList[i];
            if (!currentProcess.image.equals(processImage)) continue;
            try {
                String line;
                System.out.println("[" + killCmd + "] " + processImage + " found (pid: " + currentProcess.pid + ")");
                String[] cmdArray = new String[]{killCmd, String.valueOf(currentProcess.pid)};
                InputStream in = Runtime.getRuntime().exec(cmdArray).getInputStream();
                BufferedReader inReader = new BufferedReader(new InputStreamReader(in));
                while ((line = inReader.readLine()) != null) {
                    System.out.println(line);
                }
                inReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (--lookUpTentatives > 0) {
                Thread.sleep(lookUpTimeOut);
                this.killAllWithLookUp(taskListCmd, processImage, killCmd, lookUpTimeOut, lookUpTentatives);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public boolean isAlive(Process[] process, String image) {
        if (process == null) {
            return false;
        }
        int i = process.length;
        while (--i >= 0) {
            Process currentProc = process[i];
            if (!currentProc.image.equals(image)) continue;
            return true;
        }
        return false;
    }

    public void refreshProcessList(String taskListCmd) {
        this.processList = this.listAllProcess(taskListCmd);
    }

    @Override
    public void run() {
        String taskName = ((KillProcessManagerOptions)this.options).taskName;
        String killCmd = ((KillProcessManagerOptions)this.options).killCmd;
        String taskListCmd = ((KillProcessManagerOptions)this.options).taskListCmd;
        int lookUpTimeOut = ((KillProcessManagerOptions)this.options).lookUpTimeOut;
        int lookUpTentatives = ((KillProcessManagerOptions)this.options).lookUpTentatives;
        if (taskName != null && killCmd != null) {
            this.killAllWithLookUp(taskListCmd, taskName, killCmd, lookUpTimeOut, lookUpTentatives);
        }
    }
}

