/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.image;

import com.is2t.image.ImageSize;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ImageSizeTask
extends Task {
    private File imagePath;
    private String widthProperty;
    private String heightProperty;

    public void setImagePath(File imagePath) {
        this.imagePath = imagePath;
    }

    public void setWidthProperty(String property) {
        this.widthProperty = property;
    }

    public void setHeightProperty(String property) {
        this.heightProperty = property;
    }

    public void execute() throws BuildException {
        ImageSize imageSize;
        if (this.imagePath == null) {
            throw new BuildException("imagePath is mandatory for ImageSize");
        }
        if (this.widthProperty == null && this.heightProperty == null) {
            throw new BuildException("widthProperty and/or heightProperty are mandatory for ImageSize");
        }
        try {
            imageSize = ImageSize.compute(this.imagePath);
        }
        catch (Throwable e) {
            throw new BuildException(e);
        }
        if (this.widthProperty != null) {
            this.getProject().setProperty(this.widthProperty, String.valueOf(imageSize.width));
        }
        if (this.heightProperty != null) {
            this.getProject().setProperty(this.heightProperty, String.valueOf(imageSize.height));
        }
    }
}

