/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.filesystem.visitor.jar;

import com.is2t.filesystem.visitor.DirectoryVisitable;
import com.is2t.filesystem.visitor.IDirectoryIterator;
import com.is2t.filesystem.visitor.IFileSystemVisitable;
import com.is2t.filesystem.visitor.jar.JarEntryVisitable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarFileVisitable
extends DirectoryVisitable {
    private final JarFile wrappedEntry;

    public JarFileVisitable(JarFile wrappedEntry) {
        this.wrappedEntry = wrappedEntry;
    }

    @Override
    public IDirectoryIterator iterator() {
        final Enumeration<JarEntry> entries = this.wrappedEntry.entries();
        return new IDirectoryIterator(){

            @Override
            public IFileSystemVisitable next() {
                return new JarEntryVisitable(JarFileVisitable.this.wrappedEntry, (JarEntry)entries.nextElement());
            }

            @Override
            public boolean hasNext() {
                return entries.hasMoreElements();
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public String getName() {
        return this.wrappedEntry.getName();
    }

    @Override
    public boolean create() throws IOException {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }
}

