/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.filesystem.visitor.fs;

import com.is2t.filesystem.visitor.DirectoryVisitable;
import com.is2t.filesystem.visitor.IDirectoryIterator;
import com.is2t.filesystem.visitor.IFileSystemVisitable;
import com.is2t.filesystem.visitor.fs.FSFile;
import java.io.File;

public class FSDir
extends DirectoryVisitable {
    private final File wrappedDirectory;
    private final IFileSystemVisitable[] abstractChildren;

    public FSDir(File wrappedDirectory) {
        if (!wrappedDirectory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.wrappedDirectory = wrappedDirectory;
        File[] children = wrappedDirectory.listFiles();
        int nChildren = children.length;
        this.abstractChildren = new IFileSystemVisitable[nChildren];
        int i = nChildren;
        while (--i >= 0) {
            File currentChild = children[i];
            this.abstractChildren[i] = currentChild.isDirectory() ? new FSDir(currentChild) : new FSFile(currentChild);
        }
    }

    @Override
    public IDirectoryIterator iterator() {
        return new IDirectoryIterator(){
            private int currentChildPtr;

            @Override
            public boolean hasNext() {
                IFileSystemVisitable[] abstractChildren = FSDir.this.abstractChildren;
                return this.currentChildPtr < abstractChildren.length;
            }

            @Override
            public IFileSystemVisitable next() {
                IFileSystemVisitable[] abstractChildren = FSDir.this.abstractChildren;
                return abstractChildren[this.currentChildPtr++];
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public String getName() {
        return this.wrappedDirectory.getAbsolutePath();
    }

    @Override
    public boolean create() {
        return this.wrappedDirectory.mkdirs();
    }

    @Override
    public boolean delete() {
        return this.wrappedDirectory.delete();
    }
}

