/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.classpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;

public class UnpackingClasspath {
    String outputDir;
    String classpath;

    public void execute() throws BuildException {
        String[] classpathSplit = this.classpath.split(File.pathSeparator);
        int arraySize = classpathSplit.length;
        int i = -1;
        while (++i < arraySize) {
            String path = classpathSplit[i];
            File f = new File(path);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                this.fileTreeCopy(path, this.outputDir);
                continue;
            }
            this.unzipFiles(path, this.outputDir);
        }
    }

    public void fileTreeCopy(String src, String dest) {
        File srcFile = new File(src);
        File destFile = new File(dest);
        if (!destFile.exists() && srcFile.isDirectory()) {
            destFile.mkdirs();
        }
        if (srcFile.isFile()) {
            this.fileCopy(srcFile, destFile);
        } else if (srcFile.isDirectory()) {
            for (File f : srcFile.listFiles()) {
                this.fileTreeCopy(f.getAbsolutePath(), destFile.getAbsoluteFile() + File.separator + f.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fileCopy(File src, File dest) {
        int bufferSize = 524288;
        boolean result = false;
        FileInputStream srcFile = null;
        FileOutputStream destFile = null;
        try {
            int readLength;
            if (dest.exists()) {
                boolean bl = result;
                return bl;
            }
            dest.createNewFile();
            srcFile = new FileInputStream(src);
            destFile = new FileOutputStream(dest);
            byte[] buffer = new byte[bufferSize];
            while ((readLength = srcFile.read(buffer)) != -1) {
                destFile.write(buffer, 0, readLength);
            }
            result = true;
        }
        catch (FileNotFoundException f) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                srcFile.close();
                destFile.close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    public void unzipFiles(String zipFileName, String dest) {
        int bufferSize = 1024;
        File destFile = new File(dest);
        try {
            if (!destFile.exists()) {
                destFile.mkdir();
            }
            ZipFile zf = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int readLength;
                ZipEntry zipEntry = entries.nextElement();
                String outputFileName = this.outputDir + File.separatorChar + zipEntry.getName();
                File outputFile = new File(outputFileName);
                if (outputFile.exists()) continue;
                if (zipEntry.isDirectory()) {
                    outputFile.mkdir();
                    continue;
                }
                int lastIndexSepParentDir = outputFileName.lastIndexOf(File.separator);
                String parentDirPath = outputFileName.substring(0, lastIndexSepParentDir);
                File parentDir = new File(parentDirPath);
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                outputFile.createNewFile();
                FileOutputStream out = new FileOutputStream(outputFile);
                InputStream in = zf.getInputStream(zipEntry);
                byte[] buffer = new byte[bufferSize];
                while ((readLength = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, readLength);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (ZipException e) {
            System.err.println("The file " + zipFileName + " is corrupted.");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

