/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.classpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;

public class ResourcesExtractor {
    public String srcOutputDir;
    public String destOutputDir;
    public String resourcesPath;

    public void execute() throws BuildException {
        int resSize;
        if (this.resourcesPath == null) {
            throw new BuildException("resourcesPath attribute not set.");
        }
        if (this.srcOutputDir == null) {
            throw new BuildException("outputDir attribute not set.");
        }
        String[] resources = this.resourcesPath.split(File.pathSeparator);
        int i = resSize = resources.length;
        while (--i >= 0) {
            int lastIndexDir;
            String currentRes = resources[i];
            currentRes = currentRes.replace('/', File.separatorChar);
            String fileResFullPath = this.srcOutputDir + File.separator + currentRes;
            File currentResFile = new File(fileResFullPath);
            if (!currentResFile.exists()) {
                throw new BuildException(fileResFullPath + " does not exists.");
            }
            String destFileFullName = this.destOutputDir + File.separator + currentRes;
            String destDir = destFileFullName.substring(0, lastIndexDir = destFileFullName.lastIndexOf(File.separator));
            File destDirFile = new File(destDir);
            if (!destDirFile.exists()) {
                destDirFile.mkdirs();
            }
            this.fileCopy(currentResFile, new File(destFileFullName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fileCopy(File src, File dest) {
        int bufferSize = 524288;
        boolean result = false;
        FileInputStream srcFile = null;
        FileOutputStream destFile = null;
        try {
            int readLength;
            if (dest.exists()) {
                boolean bl = result;
                return bl;
            }
            dest.createNewFile();
            srcFile = new FileInputStream(src);
            destFile = new FileOutputStream(dest);
            byte[] buffer = new byte[bufferSize];
            while ((readLength = srcFile.read(buffer)) != -1) {
                destFile.write(buffer, 0, readLength);
            }
            result = true;
        }
        catch (FileNotFoundException f) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                srcFile.close();
                destFile.close();
            }
            catch (Exception e) {}
        }
        return result;
    }
}

