/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.classpath;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipException;
import org.apache.tools.ant.BuildException;

public class ClasspathUnifier {
    String classpath;
    String finalJar;
    JarOutputStream finalJarOutputStream;

    public ClasspathUnifier(String classpath, String finalJar) {
        this.classpath = classpath;
        this.finalJar = finalJar;
    }

    public void unify() throws BuildException {
        String[] classpathElements = this.classpath.split(File.pathSeparator);
        File finalJarFile = new File(this.finalJar);
        if (finalJarFile.exists()) {
            throw new BuildException("The finalJar " + this.finalJar + " already exists.");
        }
        try {
            finalJarFile.createNewFile();
            this.finalJarOutputStream = new JarOutputStream(new FileOutputStream(finalJarFile));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
        int i = classpathElements.length;
        while (--i >= 0) {
            File classpathElement = new File(classpathElements[i]);
            if (classpathElement.exists()) {
                if (classpathElement.isDirectory()) {
                    File[] classpathElementFiles = classpathElement.listFiles();
                    int j = classpathElementFiles.length;
                    while (--j >= 0) {
                        File classpathElementFile = classpathElementFiles[j];
                        if (classpathElementFile.isDirectory()) {
                            this.addDirectoryToFinalJar(classpathElement, classpathElementFile);
                            continue;
                        }
                        this.addFileToFinalJar(classpathElement, classpathElementFile);
                    }
                    continue;
                }
                if (classpathElement.getName().indexOf(".jar") == -1 && classpathElement.getName().indexOf(".zip") == -1) continue;
                this.addJarToFinalJar(classpathElement);
                continue;
            }
            System.out.println("Warning: Classpath entry " + classpathElement + " does not exist.");
        }
        try {
            this.finalJarOutputStream.flush();
            this.finalJarOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addJarToFinalJar(File classpathElement) throws BuildException {
        try {
            JarFile classpathElementJarFile = new JarFile(classpathElement);
            Enumeration<JarEntry> entries = classpathElementJarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.startsWith("META-INF")) continue;
                try {
                    this.finalJarOutputStream.putNextEntry(entry);
                }
                catch (ZipException e) {
                    if (e.getMessage().startsWith("duplicate")) continue;
                    throw new BuildException(e.getMessage());
                }
                InputStream is = classpathElementJarFile.getInputStream(entry);
                DataInputStream dis = new DataInputStream(is);
                int entryLength = dis.available();
                byte[] entryData = new byte[entryLength];
                dis.readFully(entryData);
                this.finalJarOutputStream.write(entryData);
                this.finalJarOutputStream.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
    }

    private void addDirectoryToFinalJar(File classpathRoot, File classpathElement) {
        File[] classpathElementFiles = classpathElement.listFiles();
        int i = classpathElementFiles.length;
        while (--i >= 0) {
            File classpathElementFile = classpathElementFiles[i];
            if (classpathElementFile.isDirectory()) {
                this.addDirectoryToFinalJar(classpathRoot, classpathElementFile);
                continue;
            }
            this.addFileToFinalJar(classpathRoot, classpathElementFile);
        }
    }

    private void addFileToFinalJar(File classpathRoot, File classpathElement) {
        int abstractClasspathRootPathIndex;
        String entryName = null;
        String abstractClasspathRootPath = classpathRoot.getAbsolutePath();
        int abstractClasspathRootPathLength = abstractClasspathRootPath.length();
        String classpathElementPath = classpathElement.getAbsolutePath();
        entryName = classpathElementPath.substring((abstractClasspathRootPathIndex = classpathElementPath.indexOf(abstractClasspathRootPath)) + 1 + abstractClasspathRootPathLength);
        if (entryName.startsWith("META-INF")) {
            return;
        }
        try {
            JarEntry entry = new JarEntry(entryName);
            try {
                this.finalJarOutputStream.putNextEntry(entry);
            }
            catch (ZipException e) {
                if (e.getMessage().startsWith("duplicate")) {
                    return;
                }
                throw new BuildException(e.getMessage());
            }
            FileInputStream is = new FileInputStream(classpathElement);
            DataInputStream dis = new DataInputStream(is);
            int entryLength = dis.available();
            byte[] entryData = new byte[entryLength];
            dis.readFully(entryData);
            this.finalJarOutputStream.write(entryData);
            this.finalJarOutputStream.closeEntry();
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage());
        }
    }
}

