/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.classpath;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;

public class ClasspathExcluder {
    public static final char SEPARATOR = ',';
    public String classpath;
    public String exclude;
    public String result;
    public String excludeMode;

    public void execute() throws BuildException {
        if (this.classpath == null) {
            throw new BuildException("classpath attribute not set.");
        }
        if (this.exclude == null) {
            throw new BuildException("excludes attribute not set.");
        }
        Vector<String> srcList = this.cut(this.classpath, File.pathSeparatorChar);
        Vector<String> excludeList = this.cut(this.exclude, ',');
        StringBuffer result = new StringBuffer();
        block0: for (String s : srcList) {
            for (String exclude : excludeList) {
                if (!this.isExcluded(s, exclude)) continue;
                continue block0;
            }
            result.append(s).append(File.pathSeparatorChar);
        }
        this.result = result.toString();
    }

    private boolean isExcluded(String path, String exclude) {
        if (this.excludeMode.equals("prefix")) {
            return path.startsWith(exclude);
        }
        if (this.excludeMode.equals("suffix")) {
            return path.endsWith(exclude);
        }
        if (this.excludeMode.equals("equal")) {
            return path.endsWith(exclude);
        }
        return path.endsWith(exclude);
    }

    private Vector<String> cut(String s, char separator) {
        String item;
        int newSep;
        Vector<String> result = new Vector<String>();
        int lastSep = 0;
        while ((newSep = s.indexOf(separator, lastSep)) != -1) {
            item = s.substring(lastSep, newSep).trim();
            if (item.length() != 0) {
                result.add(item);
            }
            lastSep = newSep + 1;
        }
        item = s.substring(lastSep, s.length()).trim();
        if (item.length() != 0) {
            result.add(item);
        }
        return result;
    }
}

