/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.apichecker;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class ApiChecker {
    private URLClassLoader implLoader;
    private URLClassLoader apiLoader;
    private String[] apiPaths;

    public static void main(String[] args) throws Exception {
        String[] errors;
        if (args.length < 3) {
            throw new IllegalArgumentException("ApiChecker requires three args: api-path, other-api-paths(comma separated), impl-paths(comma separated)");
        }
        String apiClasspath = args[0];
        String otherApiPaths = args[1];
        String implClasspath = args[2];
        ApiChecker apiChecker = new ApiChecker(apiClasspath, otherApiPaths.split(","), implClasspath.split(","));
        for (String string : errors = apiChecker.checkAllClasses()) {
            System.err.println("*** " + string);
        }
        if (errors.length > 0) {
            System.exit(-1);
        }
    }

    public ApiChecker(String apiPath, String[] apiOtherPaths, String[] implPaths) throws Exception {
        URL[] apiUrls = new URL[apiOtherPaths.length + 1];
        apiUrls[0] = new URL("file://" + apiPath);
        for (int i = 1; i < apiOtherPaths.length; ++i) {
            apiUrls[i] = new URL("file://" + apiOtherPaths[i] + "/");
        }
        URL[] implUrls = new URL[implPaths.length];
        for (int i = 0; i < implPaths.length; ++i) {
            implUrls[i] = new URL("file://" + implPaths[i] + "/");
        }
        this.implLoader = new URLClassLoader(implUrls, null);
        this.apiLoader = new URLClassLoader(apiUrls, null);
        this.apiPaths = new String[]{apiPath};
    }

    public ApiChecker(String[] apiPaths, String[] implPaths) throws Exception {
        int apiPathsLength = apiPaths.length;
        URL[] apiUrls = new URL[apiPathsLength];
        int i = -1;
        while (++i < apiPathsLength) {
            apiUrls[i] = new URL("file://" + apiPaths[i] + "/");
        }
        int implPathsLength = implPaths.length;
        URL[] implUrls = new URL[implPathsLength];
        int i2 = -1;
        while (++i2 < implPathsLength) {
            implUrls[i2] = new URL("file://" + implPaths[i2] + "/");
        }
        this.implLoader = new URLClassLoader(implUrls, null);
        this.apiLoader = new URLClassLoader(apiUrls, null);
        this.apiPaths = apiPaths;
    }

    public String[] checkAllClasses() throws Exception {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList apiClasses = new ArrayList();
        for (String apiPath : this.apiPaths) {
            Collection<Class<?>> classes = this.findClasses(new File(apiPath), "", this.apiLoader);
            apiClasses.addAll(classes);
        }
        for (Class clazz : apiClasses) {
            Class<?> implClass;
            try {
                implClass = this.implLoader.loadClass(clazz.getName());
            }
            catch (Exception e) {
                errors.add("Impl class not found: " + e.getMessage());
                continue;
            }
            errors.addAll(this.check(clazz, implClass));
        }
        return errors.toArray(new String[0]);
    }

    public String[] checkClass(String className) throws Exception {
        Class<?> implClass;
        Class<?> apiClass;
        try {
            apiClass = this.apiLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return new String[]{"Api class not found: " + e.getMessage()};
        }
        try {
            implClass = this.implLoader.loadClass(apiClass.getName());
        }
        catch (ClassNotFoundException e) {
            return new String[]{"Impl class not found: " + e.getMessage()};
        }
        return this.check(apiClass, implClass).toArray(new String[0]);
    }

    private Collection<String> check(Class<?> apiClass, Class<?> implClass) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.checkConstructors(apiClass, implClass));
        errors.addAll(this.checkMethods(apiClass, implClass));
        return errors;
    }

    private Collection<String> checkConstructors(Class<?> apiClass, Class<?> implClass) {
        ArrayList<String> errors = new ArrayList<String>();
        Constructor<?>[] apiConstructors = apiClass.getDeclaredConstructors();
        for (int i = 0; i < apiConstructors.length; ++i) {
            Constructor<?> apiConstructor = apiConstructors[i];
            Constructor<?>[] implConstructors = implClass.getDeclaredConstructors();
            boolean found = false;
            for (int j = 0; j < implConstructors.length; ++j) {
                Constructor<?> implConstructor = implConstructors[j];
                Class<?>[] apiParameterTypes = apiConstructor.getParameterTypes();
                Class<?>[] implParameterTypes = implConstructor.getParameterTypes();
                boolean matched = true;
                if (implParameterTypes.length == apiParameterTypes.length) {
                    for (int k = 0; k < apiParameterTypes.length; ++k) {
                        if (apiParameterTypes[k].getName() == implParameterTypes[k].getName()) continue;
                        matched = false;
                        break;
                    }
                } else {
                    matched = false;
                }
                if (!matched) continue;
                found = true;
                break;
            }
            if (found) continue;
            errors.add("No match for " + apiClass.getName() + " " + apiConstructor);
        }
        return errors;
    }

    private Collection<String> checkMethods(Class<?> apiClass, Class<?> implClass) {
        ArrayList<String> errors = new ArrayList<String>();
        Set<Method> implMethods = this.getAllCallableMethods(implClass);
        Method[] apiMethods = apiClass.getDeclaredMethods();
        for (int i = 0; i < apiMethods.length; ++i) {
            Method apiMethod = apiMethods[i];
            boolean found = false;
            for (Method implMethod : implMethods) {
                boolean matched = true;
                if (!this.checkModifiers(apiMethod.getModifiers(), implMethod.getModifiers())) {
                    matched = false;
                }
                if (apiMethod.getReturnType().getName() != implMethod.getReturnType().getName()) {
                    matched = false;
                } else {
                    Class<?>[] apiParameterTypes = apiMethod.getParameterTypes();
                    Class<?>[] implParameterTypes = implMethod.getParameterTypes();
                    if (implParameterTypes.length == apiParameterTypes.length) {
                        for (int k = 0; k < apiParameterTypes.length; ++k) {
                            if (apiParameterTypes[k].getName() == implParameterTypes[k].getName()) continue;
                            matched = false;
                            break;
                        }
                    } else {
                        matched = false;
                    }
                }
                if (!matched) continue;
                found = true;
                break;
            }
            if (found) continue;
            errors.add("No match for " + apiClass.getName() + " " + apiMethod);
        }
        return errors;
    }

    private Set<Method> getAllCallableMethods(Class<?> implClass) {
        HashSet<Method> result = new HashSet<Method>();
        result.addAll(Arrays.asList(implClass.getDeclaredMethods()));
        Collection<Class<?>> parents = this.getAllParents(implClass);
        for (Class<?> parentClass : parents) {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = parentClass.getDeclaredMethods()) {
                if (Modifier.isPrivate(declaredMethod.getModifiers())) continue;
                result.add(declaredMethod);
            }
        }
        return result;
    }

    private Collection<Class<?>> getAllParents(Class<?> implClass) {
        ArrayList parents = new ArrayList();
        if (implClass.isInterface()) {
            Class<?>[] extendsInterfaces;
            for (Class<?> parentClass : extendsInterfaces = implClass.getInterfaces()) {
                parents.add(parentClass);
                parents.addAll(this.getAllParents(parentClass));
            }
        } else {
            for (implClass = implClass.getSuperclass(); implClass != null && implClass.getName() != "java.lang.Object"; implClass = implClass.getSuperclass()) {
                parents.add(implClass);
            }
        }
        return parents;
    }

    private boolean checkModifiers(int apiModifiers, int implModifiers) {
        return !(Modifier.isPublic(apiModifiers) ? !Modifier.isPublic(implModifiers) : (Modifier.isProtected(apiModifiers) ? !Modifier.isPublic(implModifiers) && !Modifier.isProtected(implModifiers) : !Modifier.isPrivate(apiModifiers) && Modifier.isPrivate(implModifiers)));
    }

    private Collection<Class<?>> findClasses(File directoryOrJar, String packageName, ClassLoader loader) throws Exception {
        File[] files;
        if (!directoryOrJar.isDirectory()) {
            return this.getClassesFromJARFile(directoryOrJar, loader);
        }
        ArrayList classes = new ArrayList();
        if (!directoryOrJar.exists()) {
            return classes;
        }
        for (File file : files = directoryOrJar.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(this.findClasses(file, (packageName.length() == 0 ? "" : packageName + ".") + file.getName(), loader));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String name = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(loader.loadClass(name));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classes;
    }

    private Set<Class<?>> getClassesFromJARFile(File jar, ClassLoader loader) throws Exception {
        JarEntry jarEntry;
        HashSet classes = new HashSet();
        JarInputStream jarFile = new JarInputStream(new FileInputStream(jar));
        do {
            String className;
            if ((jarEntry = jarFile.getNextJarEntry()) == null || !(className = jarEntry.getName()).endsWith(".class")) continue;
            className = this.stripFilenameExtension(className);
            classes.add(loader.loadClass(className.replace('/', '.')));
        } while (jarEntry != null);
        return classes;
    }

    private String stripFilenameExtension(String className) {
        return className.substring(0, className.indexOf(46));
    }
}

