/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.ant.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;

public class PathResources
implements ResourceCollection {
    private String resources;
    private String[] pathLists;
    private List<Resource> filesResources;

    public void setResources(String resources) {
        this.resources = resources;
    }

    public void setPath(Path path) {
        this.pathLists = path.list();
    }

    public boolean isFilesystemOnly() {
        return true;
    }

    public Iterator<Resource> iterator() {
        this.initialize();
        return this.filesResources.iterator();
    }

    public int size() {
        this.initialize();
        return this.filesResources.size();
    }

    private void initialize() {
        if (this.filesResources != null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.resources, ":;");
        this.filesResources = new ArrayList<Resource>();
        block0: while (stringTokenizer.hasMoreTokens()) {
            String resource = stringTokenizer.nextToken();
            for (String path : this.pathLists) {
                File dir = new File(path);
                File file = new File(dir, resource);
                if (!file.exists()) continue;
                if (FileUtils.isAbsolutePath((String)resource)) {
                    resource = resource.substring(1);
                }
                this.filesResources.add((Resource)new FileResource(dir, resource));
                continue block0;
            }
        }
    }
}

