/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.ant.process;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class LockTask
extends Task {
    String duration;
    String path;
    String property;

    public void setMaxDuration(String duration) {
        this.duration = duration;
    }

    public void setFile(String file) {
        this.path = file.trim();
    }

    public void setProperty(String property) {
        if ((property = property.trim()).length() > 0) {
            this.property = property;
        }
    }

    public void execute() throws BuildException {
        try {
            this.execute0();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void execute0() throws BuildException {
        int maxMillis;
        try {
            maxMillis = Integer.parseInt(this.duration) * 1000;
        }
        catch (Exception e) {
            throw new BuildException("Invalid max duration: " + this.duration + "; value in seconds expected.");
        }
        if (this.path == null || this.path.length() == 0) {
            throw new BuildException("Invalid lock file path");
        }
        File file = new File(this.path);
        if (file.isDirectory()) {
            throw new BuildException("Invalid lock file path: it denotes a directory: " + this.path);
        }
        if (file.exists() && new Date(file.lastModified() + (long)maxMillis).compareTo(new Date()) < 0) {
            System.out.print("Delete old file (file = ");
            System.out.print(new Date(file.lastModified()));
            System.out.print(", date = ");
            System.out.print(new Date());
            System.out.println();
            file.delete();
        }
        Date max = new Date(System.currentTimeMillis() + (long)maxMillis);
        boolean locked = false;
        while (!locked && max.compareTo(new Date()) >= 0) {
            if (file.exists()) continue;
            try {
                locked = file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create lock file: " + file);
            }
        }
        if (!locked) {
            System.out.println("Lock timeout!");
            if (this.property != null) {
                this.getProject().setProperty(this.property, "set");
            }
        } else {
            System.out.println("Locked got!");
        }
    }
}

