/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.ant.path;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.selectors.FilenameSelector;

public class PathExpanderTask
extends Task {
    private static final String DEFAULT_INCLUDES = "**/*";
    public String inputPathId;
    public String outputPathId;
    public String excludes;
    public String includes;

    public void setInputPathId(String pathId) {
        this.inputPathId = pathId;
    }

    public void setOutputPathId(String pathId) {
        this.outputPathId = pathId;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public void execute() throws BuildException {
        if (this.inputPathId == null || this.outputPathId == null) {
            throw new BuildException("inputPathId and outputPathId are mandatory for PathExpander.");
        }
        Project project = this.getProject();
        Object inputPathObject = project.getReference(this.inputPathId);
        if (inputPathObject == null) {
            throw new BuildException("Unknown reference to " + this.inputPathId + ".");
        }
        if (!(inputPathObject instanceof Path)) {
            throw new BuildException("Invalid path reference " + this.inputPathId + ".");
        }
        if (this.includes == null) {
            this.includes = DEFAULT_INCLUDES;
        }
        Path inputPath = (Path)inputPathObject;
        String[] list = inputPath.list();
        Path outputPath = new Path(project);
        for (String filepath : list) {
            File file = new File(filepath);
            FileSet fs = new FileSet();
            fs.setIncludes(this.includes);
            if (this.excludes != null && !this.excludes.isEmpty()) {
                fs.setExcludes(this.excludes);
            }
            if (file.isDirectory()) {
                fs.setDir(file);
                FilenameSelector selector = new FilenameSelector();
                selector.setName(DEFAULT_INCLUDES);
                fs.addFilename(selector);
            } else {
                fs.setFile(file);
            }
            outputPath.addFileset(fs);
        }
        project.addReference(this.outputPathId, (Object)outputPath);
    }
}

