/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.ant.option;

import com.is2t.ant.option.Deprecated;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class DefineOptionTask
extends Task {
    private String name;
    private String defaultValue;
    private final ArrayList<Deprecated> deprecatedOptions = new ArrayList();

    public void setName(String name) {
        this.name = name;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void addDeprecated(Deprecated deprecatedOption) {
        this.deprecatedOptions.add(deprecatedOption);
    }

    public void execute() throws BuildException {
        Project project = this.getProject();
        if (this.name == null) {
            throw new BuildException("Please specify 'propertyName' attribute");
        }
        if (this.defaultValue == null) {
            throw new BuildException("Please specify 'defaultValue' attribute");
        }
        for (Deprecated dopt : this.deprecatedOptions) {
            String deprecatedName = dopt.getName();
            if (deprecatedName == null) {
                throw new BuildException("Please specify 'name' attribute for 'deprecated' element");
            }
            String deprecatedValue = this.getValue(deprecatedName);
            if (deprecatedValue == null) continue;
            if (this.isSet(this.name)) {
                String value = this.getValue(this.name);
                throw new BuildException("Option '" + deprecatedName + "' (set to '" + deprecatedValue + "') is deprecated in favor of '" + this.name + "' (set to '" + value + "')");
            }
            project.log("WARNING: option '" + deprecatedName + "' is deprecated in favor of '" + this.name + "' (automatically set to '" + deprecatedValue + "')");
            project.setProperty(this.name, deprecatedValue);
        }
        if (!this.isSet(this.name)) {
            project.log("WARNING: option '" + this.name + "' is not defined (automatically set to '" + this.defaultValue + "')");
            project.setProperty(this.name, this.defaultValue);
        }
    }

    private String getValue(String propertyName) {
        return this.getProject().getProperty(propertyName);
    }

    private boolean isSet(String propertyName) {
        return this.getValue(propertyName) != null;
    }
}

