/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.ant.jar;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.resources.FileResourceIterator;

public class Jar2Task
extends Jar {
    Collection<PathElement> pathElements = new ArrayList<PathElement>();

    public PathElement createPathElement() {
        PathElement pathElement = new PathElement();
        this.pathElements.add(pathElement);
        return pathElement;
    }

    private void analyse(PathElement pathElement) {
        String[] list;
        for (String filepath : list = pathElement.getParts()) {
            if (filepath.endsWith(".jar")) {
                ZipFileSet zipFileSet = new ZipFileSet();
                zipFileSet.setSrc(new File(filepath));
                this.addZipfileset(zipFileSet);
                continue;
            }
            FileSet fileSet = new FileSet();
            fileSet.setDir(new File(filepath));
            this.addFileset(fileSet);
        }
    }

    public void execute() throws BuildException {
        for (PathElement pathElement : this.pathElements) {
            this.analyse(pathElement);
        }
        super.execute();
    }

    public class PathElement
    implements ResourceCollection {
        private String[] parts;

        public void setLocation(File loc) {
            this.parts = new String[]{Path.translateFile((String)loc.getAbsolutePath())};
        }

        public void setPath(String path) {
            this.parts = Path.translatePath((Project)Jar2Task.this.getProject(), (String)path);
        }

        public String[] getParts() {
            return this.parts;
        }

        public Iterator iterator() {
            return new FileResourceIterator(Jar2Task.this.getProject(), null, this.parts);
        }

        public boolean isFilesystemOnly() {
            return true;
        }

        public int size() {
            return this.parts == null ? 0 : this.parts.length;
        }
    }
}

