/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.tools;

import com.is2t.microej.workbench.ext.tools.JPFList;
import com.is2t.microej.workbench.std.launch.ext.CategoryPage;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.JPFExtensionRoot;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class Tools {
    public static final Group[] EMPTY_GROUP_ARRAY = new Group[0];
    private static final String[] KILO_UNITS = new String[]{"KiB", "KB", "Ki", "K"};
    private static final String[] MEGA_UNITS = new String[]{"MiB", "MB", "Mi", "M"};
    private static final String[] GIGA_UNITS = new String[]{"GiB", "GB", "Gi", "G"};
    private static final int KILO = 1024;

    public static int parseInt(String s) {
        long val = Tools.parseLong(s);
        if (val < Integer.MIN_VALUE || val > Integer.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (int)val;
    }

    public static int parseUInt(String s) {
        long val = Tools.parseLong(s);
        if (val < 0L || val > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        return (int)val;
    }

    public static long parseLong(String s) {
        try {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                if (s.startsWith("0x-")) {
                    throw new NumberFormatException();
                }
                if (s.startsWith("0x")) {
                    return Long.parseLong(s.substring(2), 16);
                }
                if (s.startsWith("-0x")) {
                    return Long.parseLong("-".concat(s.substring(3)), 16);
                }
                throw new NumberFormatException();
            }
        }
        catch (Exception exception) {
            throw new NumberFormatException();
        }
    }

    public static int[] parseIPV4Address(String value) {
        if (value.equals("localhost")) {
            int[] nArray = new int[4];
            nArray[0] = 127;
            nArray[3] = 1;
            return nArray;
        }
        String[] elements = value.split("\\.");
        if (elements.length != 4) {
            return null;
        }
        int[] result = new int[4];
        int i = elements.length;
        while (--i >= 0) {
            try {
                result[i] = Integer.parseInt(elements[i]);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return result;
    }

    public static HiddenOption buildCheckBoxExtendedOption(CheckBoxOption box, String value) {
        HiddenOption opt = new HiddenOption("", String.valueOf(box.outputProperty) + ".value", value);
        opt.setEnableCondition((Expression)new CheckBoxSelected(box));
        return opt;
    }

    public static Group[] toGroupArray(JPFList list) {
        return list.toArray(EMPTY_GROUP_ARRAY);
    }

    public static String getHumanReadableMemorySize(long size) {
        if (size >= 0x40000000L) {
            double val = (double)size / 1.073741824E9;
            NumberFormat format = Tools.getMemorySizeFormat();
            return format.format(val).concat(" ").concat(GIGA_UNITS[0]);
        }
        if (size >= 0x100000L) {
            double val = (double)size / 1048576.0;
            NumberFormat format = Tools.getMemorySizeFormat();
            return format.format(val).concat(" ").concat(MEGA_UNITS[0]);
        }
        if (size >= 1024L) {
            double val = (double)size / 1024.0;
            NumberFormat format = Tools.getMemorySizeFormat();
            return format.format(val).concat(" ").concat(KILO_UNITS[0]);
        }
        return Long.toString(size);
    }

    public static long getMemorySize(String text) throws NumberFormatException {
        String numericalString = Tools.endsWith(text = text.trim(), KILO_UNITS);
        if (numericalString != null) {
            return Tools.getSizeValue(numericalString, 1024L);
        }
        numericalString = Tools.endsWith(text, MEGA_UNITS);
        if (numericalString != null) {
            return Tools.getSizeValue(numericalString, 0x100000L);
        }
        numericalString = Tools.endsWith(text, GIGA_UNITS);
        if (numericalString != null) {
            return Tools.getSizeValue(numericalString, 0x40000000L);
        }
        return Tools.getSizeValue(text, 1L);
    }

    private static String endsWith(String text, String[] units) {
        int length = units.length;
        int i = 0;
        while (i < length) {
            if (text.endsWith(units[i])) {
                return text.substring(0, text.lastIndexOf(units[i]));
            }
            ++i;
        }
        return null;
    }

    private static long getSizeValue(String text, long unit) throws NumberFormatException {
        double num;
        if ((text = text.trim()).indexOf("e") != -1 || text.indexOf("E") != -1) {
            throw new NumberFormatException();
        }
        NumberFormat format = Tools.getMemorySizeFormat();
        try {
            Number n = format.parse(text);
            num = n.doubleValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException();
        }
        if ((num *= (double)unit) < 0.0 || num > 9.223372036854776E18) {
            throw new NumberFormatException();
        }
        return (long)num;
    }

    private static NumberFormat getMemorySizeFormat() {
        NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
        format.setMaximumFractionDigits(3);
        return format;
    }

    public static JPFExtensionRoot createJPFExtensionRoot(CategoryPage page) {
        return Tools.createJPFExtensionRoot(new CategoryPage[]{page});
    }

    public static JPFExtensionRoot createJPFExtensionRoot(CategoryPage[] pages) {
        return new JPFExtensionRoot(new CategoryPage(pages));
    }
}

