/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.lib;

import com.is2t.microej.workbench.ext.Page2;
import com.is2t.microej.workbench.ext.pages.LibPage;
import com.is2t.microej.workbench.ext.pages.lib.ESRMessages;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;

public class PAPPage
extends Page2 {
    protected String version;

    public PAPPage(String version) {
        super(LibPage.class);
        this.version = version;
    }

    @Override
    protected Group getCategoryPageGroup() {
        return this.buildPAPPropertiesGroup();
    }

    @Override
    protected String getCategoryPageName() {
        return ESRMessages.CategoryPAP;
    }

    public Group buildPAPPropertiesGroup() {
        CheckBoxOption url = new CheckBoxOption((ILabel)new StringLabel(String.valueOf(ESRMessages.LabelPropEjPapVendorURL) + " (" + "www.microej.com" + ")"), "ej.pap.vendor.url");
        CheckBoxOption vendor = new CheckBoxOption((ILabel)new StringLabel(String.valueOf(ESRMessages.LabelPropEjPapVendor) + " (" + "MicroEJ" + ")"), "ej.pap.vendor");
        CheckBoxOption versionBox = new CheckBoxOption((ILabel)new StringLabel(String.valueOf(ESRMessages.LabelPropEjPapVersion) + " (" + this.version + ")"), "ej.pap.version");
        url.setInitialValue(true);
        vendor.setInitialValue(true);
        versionBox.setInitialValue(true);
        url.setDescription((Description)new XHTMLDescription(ESRMessages.DocumentDescriptionESRPAPPropertiesVendorURL));
        vendor.setDescription((Description)new XHTMLDescription(ESRMessages.DocumentDescriptionESRPAPPropertiesVendor));
        versionBox.setDescription((Description)new XHTMLDescription(ESRMessages.DocumentDescriptionESRPAPPropertiesVersion));
        HiddenOption urlOpt = Tools.buildCheckBoxExtendedOption(url, "www.microej.com");
        HiddenOption vendorOpt = Tools.buildCheckBoxExtendedOption(vendor, "MicroEJ");
        HiddenOption versionOpt = Tools.buildCheckBoxExtendedOption(versionBox, this.version);
        return new LabelGroup(ESRMessages.LabelPapProperties, new PageContent[]{url, vendor, versionBox, urlOpt, vendorOpt, versionOpt}, 1);
    }
}

