/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group;

import com.is2t.microej.workbench.ext.pages.emb.MemPage;
import com.is2t.microej.workbench.ext.pages.emb.memory.Memory;
import com.is2t.microej.workbench.ext.pages.emb.memory.MemoryMessages;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunksGroup;
import java.util.ArrayList;

public class Network {
    public static final int TCPIP_BUFFERS = 0;
    public static final int TCPIP_BUFFERS_MEMORY = 1;
    public static final int ETHERNET_BUFFERS = 2;
    public static final int ETHERNET_BUFFERS_MEMORY = 3;
    public static final int THREADS_SIZE = 4;
    public static final int THREADS_MEMORY = 5;
    public static final String PROPERTY_TCPIP_BUFFERS = "ecom.network.tcpip.buffers";
    public static final String PROPERTY_ETHERNET_BUFFERS = "ecom.network.ethernet.buffers";
    public static final String PROPERTY_THREADS = "ecom.network.threads";

    public static RuntimeChunksGroup getGroup(MemPage page) {
        long threadsSize;
        long ethernetBuffers;
        ArrayList<RuntimeChunk> chunks = new ArrayList<RuntimeChunk>();
        long tcpipBuffers = page.getMemoryValue(9, 0);
        if (tcpipBuffers > 0L) {
            Memory[] mems = page.getMemories(9, 1, 0);
            int index = (int)page.getMemoryValue(9, 1, 0);
            RuntimeChunk chunk = new RuntimeChunk(MemoryMessages.NetworkLabelTcpipBuffers, mems, index, tcpipBuffers, PROPERTY_TCPIP_BUFFERS);
            chunk.enable(false);
            chunks.add(chunk);
        }
        if ((ethernetBuffers = page.getMemoryValue(9, 2)) > 0L) {
            Memory[] mems = page.getMemories(9, 3, 0);
            int index = (int)page.getMemoryValue(9, 3, 0);
            RuntimeChunk chunk = new RuntimeChunk(MemoryMessages.NetworkLabelEthernetBuffers, mems, index, ethernetBuffers, PROPERTY_ETHERNET_BUFFERS);
            chunk.enable(false);
            chunks.add(chunk);
        }
        if ((threadsSize = page.getMemoryValue(9, 4)) > 0L) {
            Memory[] mems = page.getMemories(9, 5, 0);
            int index = (int)page.getMemoryValue(9, 5, 0);
            RuntimeChunk chunk = new RuntimeChunk(MemoryMessages.NetworkLabelThreads, mems, index, threadsSize, PROPERTY_THREADS);
            chunk.enable(false);
            chunks.add(chunk);
        }
        if (chunks.isEmpty()) {
            return null;
        }
        RuntimeChunksGroup ecom = new RuntimeChunksGroup(MemoryMessages.NetworkLabel, chunks.toArray(new RuntimeChunk[0]));
        return ecom;
    }
}

