/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group;

import com.is2t.microej.workbench.ext.pages.emb.MemPage;
import com.is2t.microej.workbench.ext.pages.emb.memory.MemoryMessages;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroup;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroupConstants;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryListener;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryValidator;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeMemory;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.ThreadsNumberI;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.ext.validator.IntIntervalOptionValidator;
import com.is2t.microej.workbench.ext.validator.MultiOptionValidators;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.BooleanConstant;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class DynamicThread
extends MemoryGroup
implements MemoryGroupConstants,
ThreadsNumberI {
    public static final int NB_THREADS = 0;
    public static final int NATIVE_MEMORY = 1;
    public static final int POOL_MEMORY = 2;
    public static final int BLOCK_SIZE = 3;
    public static final int POOL_SIZE = 4;
    public static final int MAX_SIZE = 5;
    public static final int THREAD_SIZE = 6;
    public static final int IS_VISIBLE = 7;
    public static final int DEFAULT_THREAD_MIN_SIZE = 200;
    public static final String PROPERTY_NBTHREADS = "core.memory.threads";
    public static final String PROPERTY_THREADBLOCKSIZE = "core.memory.thread.block.size";
    public static final String PROPERTY_THREADPOOLSIZE = "core.memory.threads.pool";
    public static final String PROPERTY_THREADMAXSIZE = "core.memory.thread.max.size";
    public final RuntimeMemory[] nativeMemories;
    public final RuntimeMemory[] javaMemories;
    public final int defaultNbThreads;
    public final int defaultNativeMemoryIndex;
    public final int defaultJavaMemoryIndex;
    public final int blockSize;
    public final boolean blockSizeVisible;
    public final int defaultPoolSize;
    public final int defaultMaxThreadSize;
    public final int invariantSizePerThread;
    private RuntimeChunk pool;
    private final RuntimeChunk nbThreads;

    public static DynamicThread getGroup(MemPage page) {
        if (page.getMemoryValue(8, 0) != -1L) {
            return new DynamicThread(page);
        }
        return null;
    }

    private DynamicThread(MemPage mem) {
        this.nativeMemories = mem.getMemories(8, 1);
        this.javaMemories = mem.getMemories(8, 2);
        this.defaultNbThreads = (int)mem.getMemoryValue(8, 0);
        this.defaultNativeMemoryIndex = (int)mem.getMemoryValue(8, 1);
        this.defaultJavaMemoryIndex = (int)mem.getMemoryValue(8, 2);
        this.blockSize = (int)mem.getMemoryValue(8, 3);
        this.blockSizeVisible = mem.getMemoryValue(8, 7) != 0L;
        this.defaultPoolSize = (int)mem.getMemoryValue(8, 4);
        this.defaultMaxThreadSize = (int)mem.getMemoryValue(8, 5);
        this.invariantSizePerThread = (int)mem.getMemoryValue(8, 6);
        this.nbThreads = new RuntimeChunk(MemoryMessages.ThreadLabelNumberOfThreads, this.nativeMemories, this.defaultNativeMemoryIndex, this.defaultNbThreads, PROPERTY_NBTHREADS);
    }

    @Override
    public void updateSize() {
        this.pool.updateSize();
        this.nbThreads.updateSize();
    }

    @Override
    public Group getGroup(MemoryListener listener, MemoryValidator validator) {
        HiddenOption blockSize;
        final RuntimeChunk nb = this.nbThreads;
        nb.setMinSize(1L);
        nb.setElementSize(this.invariantSizePerThread);
        nb.finalize(listener, validator);
        nb.setDescription(MemoryMessages.ThreadDescThreads);
        String blockSizeProperty = PROPERTY_THREADBLOCKSIZE;
        String blockSizeValue = Integer.toString(this.blockSize);
        LabelOption blockSizeLabel = new LabelOption(MemoryMessages.ThreadLabelBlockStackSize);
        if (this.blockSizeVisible) {
            TextFieldOption blockSizeText = new TextFieldOption((ILabel)blockSizeLabel, blockSizeProperty);
            blockSizeText.setInitialValue(blockSizeValue);
            blockSizeText.setEnableCondition((Expression)BooleanConstant.FALSE);
            blockSizeText.setDescription((Description)new XHTMLDescription(MemoryMessages.ThreadDescBlock));
            blockSize = blockSizeText;
        } else {
            HiddenOption blockSizeHidden;
            blockSize = blockSizeHidden = new HiddenOption("", blockSizeProperty, blockSizeValue);
        }
        LabelOption maxLabel = new LabelOption(MemoryMessages.ThreadLabelMaxStackSize);
        final TextFieldOption max = new TextFieldOption((ILabel)maxLabel, PROPERTY_THREADMAXSIZE);
        max.setInitialValue(Integer.toString(this.defaultMaxThreadSize));
        max.setOptionValidator((OptionValidator)new IntIntervalOptionValidator(MemoryMessages.ThreadLabelMaxStackSize, 1, true));
        max.setDescription((Description)new XHTMLDescription(MemoryMessages.ThreadDescMaxStack));
        final RuntimeChunk stacks = this.pool = new RuntimeChunk(NLS.bind((String)MemoryMessages.ThreadLabelStackPoolSize, (Object)(this.blockSizeVisible ? "" : "of " + blockSizeValue + " bytes ")), this.javaMemories, this.defaultJavaMemoryIndex, this.defaultPoolSize, PROPERTY_THREADPOOLSIZE);
        stacks.setMinSize(1L);
        stacks.setElementSize(this.blockSize);
        stacks.setDescription(MemoryMessages.ThreadDescPool);
        stacks.finalize(listener, MultiOptionValidators.getOptionValidator(validator, new OptionValidator(){

            public String getErrorMessage(PageContent arg0) {
                int mx = Tools.parseUInt(max.getSelection());
                int pool = Tools.parseUInt(stacks.memorySize.getSelection());
                int n = Tools.parseUInt(nb.memorySize.getSelection());
                if (mx > pool || n > pool) {
                    return MemoryMessages.ThreadErrorTooSmallPoolSize;
                }
                return null;
            }
        }));
        int nbColumns = stacks.hasConcreteMemoryOption() ? 3 : 2;
        ArrayList<Object> contentsVect = new ArrayList<Object>();
        contentsVect.add(nb.label);
        contentsVect.add(nb.memoriesOption);
        contentsVect.add(nb.memorySize);
        contentsVect.add(stacks.label);
        contentsVect.add(stacks.memoriesOption);
        contentsVect.add(stacks.memorySize);
        if (this.blockSizeVisible) {
            contentsVect.add(blockSizeLabel);
            if (nbColumns == 3) {
                contentsVect.add(new LabelOption(""));
            }
        }
        contentsVect.add(blockSize);
        contentsVect.add(maxLabel);
        if (nbColumns == 3) {
            contentsVect.add(new LabelOption(""));
        }
        contentsVect.add(max);
        LabelGroup grp = new LabelGroup(MemoryMessages.ThreadLabelThreads, contentsVect.toArray(new PageContent[contentsVect.size()]), nbColumns);
        grp.setDescription((Description)new XHTMLDescription(MemoryMessages.ThreadDescGroup));
        return grp;
    }

    @Override
    public long getNbThreads() {
        try {
            return Tools.parseLong(this.nbThreads.memorySize.text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }
}

