/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group;

import com.is2t.microej.workbench.ext.MainPage;
import com.is2t.microej.workbench.ext.pages.emb.MemPage;
import com.is2t.microej.workbench.ext.pages.emb.memory.Memory;
import com.is2t.microej.workbench.ext.pages.emb.memory.MemoryMessages;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroupConstants;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunksGroup;

public class Console
implements MemoryGroupConstants {
    public static final int BUFFER_SIZE = 0;
    public static final int BUFFER_MINSIZE = 1;
    public static final int BUFFER_MEMORY = 2;
    public static final int NB_CLASSES = 3;
    public static final int NB_MINCLASSES = 4;
    public static final int CLASSES_MEMORY = 5;
    public static final int CLASS_SIZE = 6;
    public static final int SYSTEM_MEMORY = 7;
    public static final int SYSTEM_SIZE = 8;
    public static final int DEFAULT_CLASS_SIZE = 8;
    public static final String BUFFER_PROPERTY_HEADER = "console.logs.buffer";
    public static final String CLASSES_PROPERTY_HEADER = "console.mem.buffer";
    private static final String SYSTEM_PROPERTY_HEADER = "console.system";

    public static RuntimeChunksGroup getGroup(MemPage page) {
        int index = (int)page.getMemoryValue(4, 2, 0);
        if (index == -1) {
            return null;
        }
        RuntimeChunk[] chunks = new RuntimeChunk[3];
        Memory[] bufferMems = page.getMemories(4, 2, 0);
        long size = page.getMemoryValue(4, 0, 0);
        RuntimeChunk chunk = new RuntimeChunk(MemoryMessages.CSLLabelLogsBuffer, bufferMems, index, size, BUFFER_PROPERTY_HEADER);
        chunk.setMinSize(page.getMemoryValue(4, 1));
        chunk.setDescription(MemoryMessages.CSLDescLogsBuffer);
        chunks[0] = chunk;
        Memory[] classesMems = page.getMemories(4, 5, 0);
        index = (int)page.getMemoryValue(4, 5, 0);
        size = page.getMemoryValue(4, 6, 0);
        int nb = (int)page.getMemoryValue(4, 3, 0);
        RuntimeChunk classes = new RuntimeChunk(MemoryMessages.CSLLabelClassesBuffer, classesMems, index, nb, CLASSES_PROPERTY_HEADER);
        classes.setElementSize(size);
        classes.setMinSize(page.getMemoryValue(4, 4));
        classes.setDescription(MemoryMessages.CSLDescClassesBuffer);
        chunks[1] = classes;
        Memory[] systemMems = page.getMemories(4, 7, 0);
        index = (int)page.getMemoryValue(4, 7, 0);
        size = page.getMemoryValue(4, 8, 0);
        RuntimeChunk system = new RuntimeChunk(MemoryMessages.CSLLabelSystem, systemMems, index, size, SYSTEM_PROPERTY_HEADER);
        system.enable(false);
        system.setDescription(MemoryMessages.CSLDescSystem);
        chunks[2] = system;
        RuntimeChunksGroup csl = new RuntimeChunksGroup(MemoryMessages.CSLLabelConsole, chunks);
        csl.setEnableCondition(MainPage.onVMCSL);
        return csl;
    }
}

