/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory.runtime;

import com.is2t.microej.workbench.ext.pages.emb.memory.Chunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.Memory;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeMemory;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.ThreadsNumberI;
import com.is2t.microej.workbench.ext.tools.Tools;

public class ResourcesPoolWithStackGroup
extends RuntimeChunk {
    protected ThreadsNumberI threadsNumber;
    protected Chunk systemMemory;
    protected long internalObjectsSize;
    protected long internalObjectsInvariant;

    public ResourcesPoolWithStackGroup(String label, Memory[] stackGroupMemories, int defaultStackGroupMemoryIndex, long defaultResourcesNumber, long internalObjectsSize, long internalObjectsInvariant, String propertyHeader, ThreadsNumberI threadsNumber, Chunk systemMemory) {
        super(label, stackGroupMemories, defaultStackGroupMemoryIndex, defaultResourcesNumber, propertyHeader);
        this.threadsNumber = threadsNumber;
        this.systemMemory = systemMemory;
        this.internalObjectsSize = internalObjectsSize;
        this.internalObjectsInvariant = internalObjectsInvariant;
    }

    @Override
    public void updateSize() {
        if (!this.isUsed()) {
            return;
        }
        super.updateSize();
        if (this.systemMemory != null) {
            long nb = this.getElementsNumber();
            Memory internalObjectsMem = null;
            if (this.memories.length > 1) {
                int index = this.systemMemory.getMemoriesOptionAsCombo().combo.getSelectionIndex();
                if (index != -1) {
                    internalObjectsMem = this.systemMemory.memories[index];
                }
            } else {
                internalObjectsMem = this.systemMemory.memories[0];
            }
            if (internalObjectsMem != null) {
                ((RuntimeMemory)internalObjectsMem).add(nb * this.internalObjectsSize + this.internalObjectsInvariant);
            }
        }
    }

    protected long getElementsNumber() {
        try {
            return Tools.parseLong(this.memorySize.text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    @Override
    protected long realMemorySize() {
        long stacksNumber = this.getElementsNumber();
        if (this.threadsNumber != null) {
            long threadNumber = this.threadsNumber.getNbThreads();
            return Math.min(stacksNumber, threadNumber);
        }
        return stacksNumber;
    }
}

