/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb.memory;

import com.is2t.microej.workbench.ext.pages.emb.memory.Memory;
import com.is2t.microej.workbench.ext.pages.emb.memory.MemoryMessages;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryListener;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeMemory;
import com.is2t.microej.workbench.ext.widget.ComboOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.InputOption;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;

public abstract class Chunk {
    public static final int MEMORY_NO_USE_COMBO_INDEX = 0;
    public static final int MEMORY_NO_USE_SIZE = -1;
    public static final String PROPERTY_MEMORY = ".memory";
    public final LabelOption label;
    public final Memory[] memories;
    public final InputOption memoriesOption;
    private boolean canDisable;

    public Chunk(String label, Memory[] memories, int defaultMemIndex, String propertyHeader) {
        this.label = new LabelOption(label);
        this.memories = memories;
        this.memoriesOption = this.createMemoriesOption(memories, propertyHeader, defaultMemIndex);
    }

    public static RuntimeMemory getMemoryNotUsed() {
        return new RuntimeMemory("not used", "NOUSE", -1L);
    }

    public void finalize(MemoryListener listener) {
        if (listener != null) {
            this.memoriesOption.addOptionChangedListener((OptionChangedListener)listener);
        }
    }

    public boolean canDisable() {
        return this.canDisable;
    }

    private InputOption createMemoriesOption(Memory[] memories, String propertyHeader, int defaultMemIndex) {
        String outputProperty = String.valueOf(propertyHeader) + PROPERTY_MEMORY;
        int l = memories.length;
        if (l == 1) {
            HiddenOption option = new HiddenOption("", outputProperty, memories[0].id);
            return option;
        }
        String[] items = new String[l];
        String[] values = new String[l];
        int j = -1;
        while (++j < l) {
            Memory mem = memories[j];
            items[j] = mem.label;
            values[j] = mem.id;
            if (j != 0 || mem.size != -1L) continue;
            this.canDisable = true;
        }
        ComboOption combo = new ComboOption((ILabel)new StringLabel(""), outputProperty, items, values);
        combo.setInitialValue(defaultMemIndex);
        combo.setDescription((Description)new XHTMLDescription(MemoryMessages.DescMemoriesCombo));
        return combo;
    }

    public ComboOption getMemoriesOptionAsCombo() {
        assert (this.memories.length > 1);
        return (ComboOption)this.memoriesOption;
    }

    public boolean hasConcreteMemoryOption() {
        return this.memories.length != 1;
    }
}

