/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.emb;

import com.is2t.microej.workbench.ext.Page2;
import com.is2t.microej.workbench.ext.pages.emb.EmbMessages;
import com.is2t.microej.workbench.ext.pages.emb.RuntimePage2;
import com.is2t.microej.workbench.ext.pages.emb.memory.Chunk;
import com.is2t.microej.workbench.ext.pages.emb.memory.MemoryMessages;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroup;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryGroupConstants;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryListener;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.MemoryValidator;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeChunksGroup;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.RuntimeMemory;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.Application;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.Console;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.DynamicThread;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.ECOM;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.Heap;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.IceOS;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.MicroUI;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.Network;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.Platform;
import com.is2t.microej.workbench.ext.pages.emb.memory.runtime.group.StaticThread;
import com.is2t.microej.workbench.ext.tools.JPFList;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.expr.BinaryExpression;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;

public abstract class MemPage
extends Page2
implements MemoryGroupConstants {
    public static final int NB_ELEMENTS = 5;
    public static final String PROP_MEM_ENABLED = "memories.enabled";
    public static final int MJVM_STD = 0;
    public static final int MJVM_MNT = 1;
    public static final int MJVM_CSL = 2;
    public static final int MJVM_DBG = 3;
    public final int mjvmType;
    Group mem;
    HiddenOption memEnabled;
    MemoryListener listener;

    public MemPage() {
        this(0);
    }

    public MemPage(int mjvmType) {
        super(RuntimePage2.class);
        this.mjvmType = mjvmType;
    }

    @Override
    protected String getCategoryPageName() {
        return EmbMessages.CategoryMemoryManagement;
    }

    @Override
    protected Group getCategoryPageGroup() {
        this.mem = this.buildMemoryManagementGroup(this.getMemories(0, 0));
        this.memEnabled = new HiddenOption("", PROP_MEM_ENABLED, Boolean.toString(true));
        return new Group(new PageContent[]{this.mem, this.memEnabled}, 1);
    }

    @Override
    protected Expression getCategoryPageVisibilityExpression() {
        Expression second;
        switch (this.mjvmType) {
            default: {
                second = new BinaryExpression(4, onVMDefault, onS3);
                break;
            }
            case 1: {
                second = onVMMNT;
                break;
            }
            case 2: {
                second = onVMCSL;
                break;
            }
            case 3: {
                second = onVMDBG;
            }
        }
        return new BinaryExpression(3, this.build, second);
    }

    protected Group buildMemoryManagementGroup(RuntimeMemory[] mems) {
        PageContent[] contents;
        JPFList list = new JPFList();
        MemoryGroup threadsGroup = null;
        RuntimeChunksGroup platformGroup = null;
        Chunk systemMemory = null;
        if (this.useChunksGroup(5)) {
            platformGroup = Platform.getGroup(this);
            systemMemory = Platform.getSystemMemoryChunk();
        }
        if (this.useChunksGroup(1)) {
            list.add(Heap.getGroup(this));
        }
        if (this.useChunksGroup(7)) {
            threadsGroup = StaticThread.getGroup(this);
            list.add(threadsGroup);
        }
        if (this.useChunksGroup(8)) {
            threadsGroup = DynamicThread.getGroup(this);
            list.add(threadsGroup);
        }
        if (this.useChunksGroup(6)) {
            list.add(Application.getGroup(this));
        }
        if (this.useChunksGroup(2)) {
            list.add(MicroUI.getGroup(this));
        }
        if (this.useChunksGroup(3)) {
            list.add(ECOM.getGroup(this, threadsGroup, systemMemory));
        }
        if (this.useChunksGroup(9)) {
            list.add(Network.getGroup(this));
        }
        if (this.useChunksGroup(4)) {
            list.add(Console.getGroup(this));
        }
        if (this.useChunksGroup(10)) {
            list.add(IceOS.getGroup(this));
        }
        if (this.useChunksGroup(5)) {
            list.add(platformGroup);
        }
        list.add(this.newSpecificMemoryGroup());
        MemoryGroup[] groups = list.toArray(new MemoryGroup[0]);
        int l = groups.length;
        if (l == 0) {
            return null;
        }
        if (this.showRuntimeMemoriesGroup()) {
            MemoryValidator validator = new MemoryValidator(mems);
            MemoryListener listener = this.listener = new MemoryListener(mems, groups);
            contents = new PageContent[l + 1];
            contents[0] = this.getMemoriesGroup(mems);
            int i = l;
            while (--i >= 0) {
                MemoryGroup group = groups[i];
                if (group == null) continue;
                contents[i + 1] = group.getGroup(listener, validator);
            }
        } else {
            contents = new PageContent[l];
            int i = l;
            while (--i >= 0) {
                MemoryGroup group = groups[i];
                if (group == null) continue;
                contents[i] = group.getGroup();
            }
        }
        return new Group(contents, 1);
    }

    protected Group getMemoriesGroup(RuntimeMemory[] memories) {
        int l = memories.length;
        PageContent[] contents = new PageContent[5 * (l + 1)];
        contents[0] = new LabelOption("");
        contents[1] = new LabelOption(MemoryMessages.LabelMemoryUsed);
        contents[2] = new LabelOption(MemoryMessages.LabelMemoryFree);
        contents[3] = new LabelOption(MemoryMessages.LabelMemoryTotal);
        contents[4] = new LabelOption(MemoryMessages.LabelMemoryPercent);
        int i = -1;
        while (++i < l) {
            int j = (i + 1) * 5;
            RuntimeMemory mem = memories[i];
            contents[j] = new LabelOption(mem.label);
            contents[j + 1] = mem.memoryUsed;
            contents[j + 2] = mem.memoryFree;
            contents[j + 3] = new LabelOption(Long.toString(mem.size));
            contents[j + 4] = mem.memoryPercent;
        }
        return new LabelGroup("", contents, 5);
    }

    protected MemoryGroup[] newSpecificMemoryGroup() {
        return null;
    }

    public int useChunk(int type, int chunk) {
        return (int)this.getMemoryValue(type, chunk) == -1 ? 0 : 1;
    }

    public boolean useChunksGroup(int type) {
        switch (type) {
            case 1: {
                return true;
            }
            case 7: {
                return false;
            }
            case 8: {
                return true;
            }
            case 6: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public long getMemoryValue(int type, int action) {
        return this.getMemoryValue(type, action, -1);
    }

    public abstract long getMemoryValue(int var1, int var2, int var3);

    public RuntimeMemory[] getMemories(int type, int action) {
        return this.getMemories(type, action, -1);
    }

    public abstract RuntimeMemory[] getMemories(int var1, int var2, int var3);

    protected boolean showRuntimeMemoriesGroup() {
        return true;
    }
}

