/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.debug;

import com.is2t.microej.workbench.ext.Page2;
import com.is2t.microej.workbench.ext.pages.S3Page;
import com.is2t.microej.workbench.ext.pages.debug.DebugMessages;
import com.is2t.microej.workbench.ext.validator.IntIntervalOptionValidator;
import com.is2t.microej.workbench.std.launch.ext.CategoryPage;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.BinaryExpression;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;

public class ConsolePage
extends Page2 {
    public Group logs;

    public ConsolePage() {
        super(S3Page.class);
    }

    @Override
    protected Group getCategoryPageGroup() {
        this.logs = this.buildLogsGroup();
        return this.logs;
    }

    @Override
    protected String getCategoryPageName() {
        return DebugMessages.CategoryConsole;
    }

    @Override
    protected Expression getCategoryPageVisibilityExpression() {
        return new BinaryExpression(3, (Expression)new BinaryExpression(4, onS3, onVMCSL), this.run);
    }

    @Override
    protected void finalizeCategoryPage(CategoryPage page) {
        CheckBoxOption boardCompliant = S3Page.getBoardCompliant();
        if (boardCompliant != null) {
            BinaryExpression boardCompliantExpression = new BinaryExpression(4, onVMCSL, (Expression)new CheckBoxSelected(boardCompliant));
            this.logs.setEnableCondition((Expression)boardCompliantExpression);
        }
    }

    public Group buildLogsGroup() {
        CheckBoxOption logsLow = new CheckBoxOption((ILabel)new StringLabel(DebugMessages.LabelLogsLow), "console.logs.level.low");
        CheckBoxOption logsThread = new CheckBoxOption((ILabel)new StringLabel(DebugMessages.LabelLogsThread), "console.logs.level.thread");
        CheckBoxOption logsMonitoring = new CheckBoxOption((ILabel)new StringLabel(DebugMessages.LabelLogsMonitoring), "console.logs.level.monitoring");
        CheckBoxOption logsMemory = new CheckBoxOption((ILabel)new StringLabel(DebugMessages.LabelLogsMemory), "console.logs.level.memory");
        CheckBoxOption logsMonitors = new CheckBoxOption((ILabel)new StringLabel(DebugMessages.LabelLogsMonitors), "console.logs.level.monitors");
        CheckBoxOption logsSchedule = new CheckBoxOption((ILabel)new StringLabel(DebugMessages.LabelLogsSchedule), "console.logs.level.schedule");
        TextFieldOption logPeriod = new TextFieldOption((ILabel)new StringLabel(DebugMessages.LabelLogsPeriod), "console.logs.period");
        logsLow.setInitialValue(false);
        logsThread.setInitialValue(false);
        logsMonitoring.setInitialValue(false);
        logsMemory.setInitialValue(false);
        logsMonitors.setInitialValue(false);
        logsSchedule.setInitialValue(false);
        logPeriod.setOptionValidator((OptionValidator)new IntIntervalOptionValidator(DebugMessages.LabelLogsPeriod, 1, 60));
        logPeriod.setInitialValue("2");
        logsLow.setDescription((Description)new XHTMLDescription(DebugMessages.DocumentDescriptionLogsLow));
        logsThread.setDescription((Description)new XHTMLDescription(DebugMessages.DocumentDescriptionLogsThread));
        logsMonitoring.setDescription((Description)new XHTMLDescription(DebugMessages.DocumentDescriptionLogsMonitoring));
        logsMemory.setDescription((Description)new XHTMLDescription(DebugMessages.DocumentDescriptionLogsMemory));
        logsMonitors.setDescription((Description)new XHTMLDescription(DebugMessages.DocumentDescriptionLogsMonitors));
        logsSchedule.setDescription((Description)new XHTMLDescription(DebugMessages.DocumentDescriptionLogsSchedule));
        logPeriod.setDescription((Description)new XHTMLDescription(DebugMessages.DocumentDescriptionLogsPeriod));
        logsMonitoring.setEnableCondition(onS3);
        logPeriod.setEnableCondition(onS3);
        Group logs = new Group(new PageContent[]{logsLow, logsThread, logsMonitoring, logsMemory, logsSchedule, logsMonitors}, 3);
        Group period = new Group(new PageContent[]{logPeriod}, 1);
        LabelGroup ret = new LabelGroup(DebugMessages.GroupLogs, new PageContent[]{logs, period}, 1);
        ret.setDescription((Description)new XHTMLDescription(DebugMessages.DocumentDescriptionGroupLogs));
        return ret;
    }
}

