/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.core;

import com.is2t.microej.workbench.ext.pages.emb.EmbMessages;
import com.is2t.microej.workbench.ext.widget.ChangeCheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.InputOption;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import java.util.Collection;

public abstract class MemoryPart {
    protected LabelOption label;
    protected String checkBoxPropertyName;
    protected InputOption checkBox;
    protected boolean defaultCheckValue;
    protected long defaultValue;

    public MemoryPart(String label, long defaultSize) {
        this(label, defaultSize, null);
    }

    public MemoryPart(String label, long defaultSize, String checkBPropertyName) {
        this.label = new LabelOption(label);
        this.defaultValue = defaultSize;
        this.checkBoxPropertyName = checkBPropertyName;
        this.defaultCheckValue = defaultSize != 0L;
    }

    protected abstract void setInputOptionEnableCondition(Expression var1);

    public abstract InputOption getMemoryValueOption();

    public void setDefaultValue(boolean defaultValue) {
        this.defaultCheckValue = defaultValue;
    }

    public boolean isCheckable() {
        return this.checkBoxPropertyName != null;
    }

    public InputOption getCheckBoxOption() {
        if (this.checkBox == null) {
            if (!this.isCheckable()) {
                this.checkBox = new LabelOption("");
            } else {
                ChangeCheckBoxOption checkBox = new ChangeCheckBoxOption((ILabel)this.label, this.checkBoxPropertyName);
                checkBox.setInitialValue(this.defaultCheckValue);
                checkBox.setDescription((Description)new XHTMLDescription(EmbMessages.DocumentDescriptionHeapCheck));
                this.setInputOptionEnableCondition((Expression)new CheckBoxSelected((CheckBoxOption)checkBox));
                this.checkBox = checkBox;
            }
        }
        return this.checkBox;
    }

    public InputOption getSignOption(String label) {
        return new LabelOption(label);
    }

    public InputOption getLabelName() {
        return this.label;
    }

    public boolean isValidMemory() {
        if (!this.isCheckable()) {
            return true;
        }
        CheckBoxOption checkBox = (CheckBoxOption)this.checkBox;
        return checkBox.getSelection();
    }

    public abstract long getMemoryValue();

    public abstract OptionValidator getMemoryOptionValidator();

    public void addOptionChangedListener(OptionChangedListener listener) {
        this.getMemoryValueOption().addOptionChangedListener(listener);
    }

    public void setMemoryValidator(OptionValidator validator) {
        this.getMemoryValueOption().setOptionValidator(validator);
    }

    public abstract Collection getHiddenOptions();
}

