/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.core;

import com.is2t.microej.workbench.ext.CommonMessages;
import com.is2t.microej.workbench.ext.Page;
import com.is2t.microej.workbench.ext.pages.core.MemoryPart;
import com.is2t.microej.workbench.ext.pages.core.ThreadManagementGroup;
import com.is2t.microej.workbench.ext.pages.emb.EmbMessages;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.ext.widget.ChangeLabelOption;
import com.is2t.microej.workbench.ext.widget.HiddenOptionForSize;
import com.is2t.microej.workbench.std.launch.ext.CategoryPage;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.InputOption;
import com.is2t.microej.workbench.std.launch.ext.JPFExtensionTabNode;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.BinaryExpression;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.osgi.util.NLS;

public class MemoryPage
extends Page {
    public static final String NOSIGN = " ";
    public static final String PLUS = "+";
    public static final String MUL = "x";
    public static final String EQUAL = "=";
    public Group memoryManagement;

    public MemoryPage(Page superPage) {
        super(superPage);
    }

    @Override
    protected CategoryPage buildCategoryPage() {
        this.memoryManagement = this.buildMemoryManagementGroup();
        if (this.memoryManagement == null) {
            return null;
        }
        CheckBoxOption boardCompliant = MainPage.getSimJPFBoardCompliant();
        if (boardCompliant != null) {
            this.memoryManagement.setEnableCondition((Expression)new BinaryExpression(4, this.onVM, (Expression)new CheckBoxSelected(boardCompliant)));
        }
        CategoryPage page = new CategoryPage(EmbMessages.CategoryMemoryManagement, new Group(new PageContent[]{this.memoryManagement}, 1));
        page.setDescription((Description)new XHTMLDescription(EmbMessages.DocumentDescriptionMemoryPage, new JPFExtensionTabNode[0]));
        return page;
    }

    @Override
    protected Expression getCategoryPageVisibilityExpression() {
        return null;
    }

    public Group buildMemoryManagementGroup() {
        return null;
    }

    public Group buildMemorySpaceManagementGroup(String groupName, long fullSize, MemoryPart[] parts) {
        return this.buildMemorySpaceManagementGroup(groupName, fullSize, parts, null);
    }

    public Group buildMemorySpaceManagementGroup(String groupName, final long fullSize, final MemoryPart[] parts, Group[] subGroups) {
        final int nbParts = parts.length;
        InputOption[] checks = new InputOption[nbParts];
        InputOption[] signs = new InputOption[nbParts];
        InputOption[] labels = new InputOption[nbParts];
        final InputOption[] texts = new InputOption[nbParts];
        final OptionValidator[] validators = new OptionValidator[nbParts];
        int i = nbParts;
        while (--i >= 0) {
            MemoryPart part = parts[i];
            InputOption check = part.getCheckBoxOption();
            InputOption sign = part.getSignOption(i == 0 ? NOSIGN : PLUS);
            InputOption label = part.getLabelName();
            InputOption text = part.getMemoryValueOption();
            checks[i] = check;
            signs[i] = sign;
            labels[i] = label;
            texts[i] = text;
            validators[i] = part.getMemoryOptionValidator();
        }
        String fullSizeMem = Tools.getHumanReadableMemorySize(fullSize);
        final ChangeLabelOption userFreeSpace = new ChangeLabelOption(fullSizeMem);
        final ChangeLabelOption userSpace = new ChangeLabelOption(fullSizeMem);
        LabelOption labelUserFreeSpace = new LabelOption(EmbMessages.LabelUserFreeSpace);
        LabelOption labelUserMemorySpace = new LabelOption(EmbMessages.LabelUserMemorySpace);
        OptionValidator userSpaceGroupValidator = new OptionValidator(){

            public String getErrorMessage(PageContent arg0) {
                try {
                    int i = -1;
                    while (++i < nbParts) {
                        String error;
                        OptionValidator validator = validators[i];
                        if (validator == null || !parts[i].isValidMemory() || (error = validator.getErrorMessage((PageContent)texts[i])) == null) continue;
                        return error;
                    }
                    if (fullSize > 0L) {
                        long free = fullSize;
                        int i2 = nbParts;
                        while (--i2 >= 0) {
                            if (!parts[i2].isValidMemory()) continue;
                            free -= parts[i2].getMemoryValue();
                        }
                        if (free < 0L) {
                            return NLS.bind((String)EmbMessages.ErrorFullSpaceReached, (Object[])new Object[]{EmbMessages.LabelUserFreeSpace});
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return CommonMessages.ErrorUnknownError;
                }
            }
        };
        int i2 = nbParts;
        while (--i2 >= 0) {
            parts[i2].setMemoryValidator(userSpaceGroupValidator);
        }
        OptionChangedListener spaceModifier = new OptionChangedListener(){

            public void changed() {
                try {
                    long free = fullSize;
                    long total = 0L;
                    int i = nbParts;
                    while (--i >= 0) {
                        if (!parts[i].isValidMemory()) continue;
                        long mem = parts[i].getMemoryValue();
                        if (fullSize > 0L) {
                            free -= mem;
                            continue;
                        }
                        total += mem;
                    }
                    if (fullSize > 0L) {
                        String freeText = Tools.getHumanReadableMemorySize(free);
                        userFreeSpace.setText(freeText);
                    } else {
                        String totalText = Tools.getHumanReadableMemorySize(total);
                        userSpace.setText(totalText);
                    }
                }
                catch (Exception exception) {}
            }
        };
        int i3 = nbParts;
        while (--i3 >= 0) {
            if (parts[i3].isCheckable()) {
                parts[i3].checkBox.addOptionChangedListener(spaceModifier);
            }
            parts[i3].addOptionChangedListener(spaceModifier);
        }
        Vector<Object> content = new Vector<Object>();
        int i4 = -1;
        while (++i4 < nbParts) {
            content.add(checks[i4]);
            content.add(signs[i4]);
            content.add(labels[i4]);
            content.add(texts[i4]);
        }
        if (fullSize > 0L) {
            content.add(new LabelOption(""));
            content.add(new LabelOption(PLUS));
            content.add(labelUserFreeSpace);
            content.add((Object)userFreeSpace);
        }
        content.add(new LabelOption(""));
        content.add(new LabelOption(EQUAL));
        content.add(labelUserMemorySpace);
        content.add((Object)userSpace);
        i4 = -1;
        while (++i4 < nbParts) {
            Collection hiddens = parts[i4].getHiddenOptions();
            if (hiddens == null) continue;
            content.addAll(hiddens);
        }
        Object[] contentArray = new PageContent[content.size()];
        content.copyInto(contentArray);
        Group partsGroup = new Group((PageContent[])contentArray, 4);
        content = new Vector();
        content.add(partsGroup);
        if (subGroups != null) {
            int i5 = 0;
            while (i5 < subGroups.length) {
                Group g = subGroups[i5];
                content.add(g);
                ++i5;
            }
        }
        contentArray = new PageContent[content.size()];
        content.copyInto(contentArray);
        return new LabelGroup(groupName, (PageContent[])contentArray, 1);
    }

    public Group buildMemorySpaceManagementGroup(String groupName, MemoryPart[] parts) {
        return this.buildMemorySpaceManagementGroup(groupName, -1L, parts);
    }

    public ThreadManagementGroup buildThreadsManagementGroup() {
        String propertyHeader = MainPage.getPropertyHeader();
        LabelOption labelNbThreads = new LabelOption(EmbMessages.LabelNbThreads);
        LabelOption labelThreadSize = new LabelOption(EmbMessages.LabelThreadSize);
        LabelOption labelNativeSize = new LabelOption(EmbMessages.LabelNativeSize);
        TextFieldOption nbThreads = new TextFieldOption((ILabel)labelNbThreads, String.valueOf(propertyHeader) + "core.memory.threads");
        nbThreads.setInitialValue(Integer.toString((int)this.getMemoryValue(7)));
        TextFieldOption maxJavaStackSize = new TextFieldOption((ILabel)labelThreadSize, String.valueOf(propertyHeader) + "core.memory.javastack.size" + ".text");
        maxJavaStackSize.setInitialValue(Integer.toString((int)this.getMemoryValue(5)));
        HiddenOptionForSize hiddenThreadSize = new HiddenOptionForSize(String.valueOf(propertyHeader) + "core.memory.javastack.size", maxJavaStackSize, this.getMemoryValue(10));
        ChangeLabelOption nativeSpace = new ChangeLabelOption("");
        nbThreads.setDescription((Description)new XHTMLDescription(EmbMessages.DocumentDescriptionThreadsNumber));
        maxJavaStackSize.setDescription((Description)new XHTMLDescription(EmbMessages.DocumentDescriptionThreadJavaSize));
        nativeSpace.setDescription((Description)new XHTMLDescription(EmbMessages.DocumentDescriptionThreadNativeSize));
        Vector<Object> content = new Vector<Object>();
        content.add(labelNbThreads);
        content.add(nbThreads);
        content.add(labelNativeSize);
        content.add((Object)nativeSpace);
        content.add(labelThreadSize);
        content.add(maxJavaStackSize);
        content.add((Object)hiddenThreadSize);
        Object[] contentArray = new PageContent[content.size()];
        content.copyInto(contentArray);
        ThreadManagementGroup threadGroup = new ThreadManagementGroup(EmbMessages.GroupThreadSpace, (PageContent[])contentArray, 2);
        threadGroup.initialize(maxJavaStackSize, hiddenThreadSize, nbThreads, nativeSpace);
        return threadGroup;
    }

    public long getMemoryValue(int type) {
        switch (type) {
            case 1: {
                return 0xFFFFFFFFL;
            }
            case 2: {
                return 0x55555555L;
            }
            case 3: {
                return 0x55555555L;
            }
            case 4: {
                return 0x55555555L;
            }
            case 5: {
                return 1024L;
            }
            case 6: {
                return 1024L;
            }
            case 7: {
                return 10L;
            }
            case 8: {
                return 5120L;
            }
            case 9: {
                return 0L;
            }
            case 10: {
                return 50L;
            }
            case 11: {
                return 1L;
            }
        }
        return -1L;
    }

    public HiddenOption addTotalHeapSizeProperty(final MemoryPart[] parts) {
        String propertyHeader = MainPage.getPropertyHeader();
        final HiddenOption heapSum = new HiddenOption(null, String.valueOf(propertyHeader) + "core.memory.javaheapsum.size", "" + (this.getMemoryValue(2) + this.getMemoryValue(12)));
        OptionChangedListener heapSizeSum = new OptionChangedListener(){

            public void changed() {
                try {
                    long heapSize = 0L;
                    int i = parts.length;
                    while (--i >= 0) {
                        heapSize += parts[i].getMemoryValue();
                    }
                    heapSum.outputValue = Long.toString(heapSize);
                }
                catch (Exception exception) {}
            }
        };
        int i = parts.length;
        while (--i >= 0) {
            parts[i].getMemoryValueOption().addOptionChangedListener(heapSizeSum);
        }
        return heapSum;
    }
}

