/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microej.workbench.ext.pages.core;

import com.is2t.microej.workbench.ext.pages.core.MemoryPart;
import com.is2t.microej.workbench.ext.tools.Tools;
import com.is2t.microej.workbench.ext.widget.HiddenOptionForSize;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.InputOption;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import java.util.Collection;
import java.util.LinkedList;

public class InputMemoryPart
extends MemoryPart {
    protected TextFieldOption inputTextField;
    protected HiddenOptionForSize realSize;
    protected long minValue;

    public InputMemoryPart(String label, String propertyName, long defaultSize, long minValue, Description description) {
        this(label, propertyName, defaultSize, minValue, null, description);
    }

    public InputMemoryPart(String label, String propertyName, long defaultSize, long minValue, String checkBPropertyName, Description description) {
        super(label, defaultSize, checkBPropertyName);
        this.minValue = minValue;
        this.inputTextField = new TextFieldOption((ILabel)this.label, String.valueOf(propertyName) + ".text");
        this.inputTextField.setInitialValue(Tools.getHumanReadableMemorySize(this.defaultValue));
        this.inputTextField.setDescription(description);
        this.realSize = new HiddenOptionForSize(propertyName, this.inputTextField, minValue);
    }

    @Override
    protected void setInputOptionEnableCondition(Expression enableExpression) {
        this.inputTextField.setEnableCondition(enableExpression);
    }

    @Override
    public InputOption getMemoryValueOption() {
        return this.inputTextField;
    }

    @Override
    public long getMemoryValue() {
        return this.realSize.getValue();
    }

    @Override
    public OptionValidator getMemoryOptionValidator() {
        return this.realSize;
    }

    @Override
    public Collection getHiddenOptions() {
        LinkedList<HiddenOptionForSize> hiddenOptions = new LinkedList<HiddenOptionForSize>();
        hiddenOptions.add(this.realSize);
        return hiddenOptions;
    }
}

