/*
 * Decompiled with CFR 0.152.
 */
package ej.event;

import ej.event.Event;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class EventQueueNatives {
    private static final int EVENT_QUEUE_SIZE = 100;
    private static final Queue<Event> EVENT_QUEUE = new LinkedBlockingQueue<Event>(100);
    private static Event currentExtendedEvent;

    private EventQueueNatives() {
    }

    public static void initialize() {
        currentExtendedEvent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean offerEvent(int type, int data) {
        boolean messageSent = false;
        Event event = new Event(false, type, data, null, 0);
        Queue<Event> queue = EVENT_QUEUE;
        synchronized (queue) {
            messageSent = EVENT_QUEUE.offer(event);
            EVENT_QUEUE.notifyAll();
        }
        return messageSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean offerExtendedEvent(int type, byte[] data, int length) {
        boolean messageSent = false;
        Event event = new Event(true, type, 0, data, length);
        Queue<Event> queue = EVENT_QUEUE;
        synchronized (queue) {
            messageSent = EVENT_QUEUE.offer(event);
            EVENT_QUEUE.notifyAll();
        }
        return messageSent;
    }

    public static int waitEvent() {
        Queue<Event> queue = EVENT_QUEUE;
        synchronized (queue) {
            while (true) {
                Event event;
                if ((event = EVENT_QUEUE.poll()) != null) {
                    if (!event.isExtended()) {
                        return event.getMessage();
                    }
                    currentExtendedEvent = event;
                    return event.getMessage();
                }
                try {
                    EVENT_QUEUE.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static void startReadExtendedData(int dataLength) {
        currentExtendedEvent.startRead();
    }

    public static void endReadExtendedData() {
        currentExtendedEvent = null;
    }

    public static boolean nativeReadBoolean() throws IOException {
        return currentExtendedEvent.readOneByte() != 0;
    }

    public static byte nativeReadByte() throws IOException {
        return currentExtendedEvent.readOneByte();
    }

    public static char nativeReadChar() throws IOException {
        return (char)currentExtendedEvent.readTwoBytes();
    }

    public static double nativeReadDouble() throws IOException {
        return Double.longBitsToDouble(currentExtendedEvent.readEightBytes());
    }

    public static float nativeReadFloat() throws IOException {
        return Float.intBitsToFloat(currentExtendedEvent.readFourBytes());
    }

    public static int nativeRead(byte[] b, int off, int len) throws IOException {
        return currentExtendedEvent.read(b, off, len);
    }

    public static int nativeReadInt() throws IOException {
        return currentExtendedEvent.readFourBytes();
    }

    public static long nativeReadLong() throws IOException {
        return currentExtendedEvent.readEightBytes();
    }

    public static short nativeReadShort() throws IOException {
        return (short)currentExtendedEvent.readTwoBytes();
    }

    public static int nativeReadUnsignedByte() throws IOException {
        return currentExtendedEvent.readOneByte() & 0xFF;
    }

    public static int nativeReadUnsignedShort() throws IOException {
        return currentExtendedEvent.readTwoBytes();
    }

    public static int nativeSkipBytes(int n) {
        return currentExtendedEvent.skipBytes(n);
    }

    public static int nativeAvailable() {
        return currentExtendedEvent.available();
    }
}

